package com.artfess.base.enums;

import lombok.Getter;

/**
 * 水库水位预警等级
 */
@Getter
public enum RsvrWarnGradeEnum {
    /**
     *
     */
    FHG(1, "防洪高水位"),

    FHXZ(2, "防洪限制水位"),

    HJ(3, "校核洪水位"),

    ;

    RsvrWarnGradeEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private Integer type;

    private String desc;

    public static String getDesc(Integer type){
        if(null == type){
            return null;
        }
        RsvrWarnGradeEnum[] values = values();
        for (RsvrWarnGradeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }

}
