package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 汛期类别
 */
@Getter
public enum FstpTypeEnum {
    ONE("1", "非汛期"),

    TWO("2", "主汛期"),

    THREE("3", "后汛期"),

    FOUR("4", "过渡期"),
    ;

    FstpTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        FstpTypeEnum[] values = values();
        for (FstpTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }

}
