import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierAccessConfiguration/v1/queryPage`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 表格回显
export function dataDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierAccessConfiguration/v1/getInfo/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 导出excel
export function exportData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .download('/biz/enterprise/exportDataToExcel', 'post', data, 'arraybuffer')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 审核
export function auditData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterpriseAccess/v1/saveOrUpdateOtherInfo`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 查询评分人员/bizSupplierEnterpriseAccess/v1/getReportPanel
export function getReportPanel(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseAccess/v1/getReportPanel?id=` + id)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 查询-计算现场评审评分 /bizSupplierEnterpriseAccess/v1/getEnterpriseScore
export function getEnterpriseScore(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseAccess/v1/getEnterpriseScore?id=` + id)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
