package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 启禁用枚举
 */
@Getter
public enum EnableStatusEnum {
    /**
     * 启用
     */
    Y("1", "启用"),

    N("0", "禁用"),
    ;

    EnableStatusEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        EnableStatusEnum[] values = values();
        for (EnableStatusEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
