package com.artfess.workflow.runtime.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.workflow.runtime.dao.BpmPrintRecordDao;
import com.artfess.workflow.runtime.manager.BpmPrintRecordManager;
import com.artfess.workflow.runtime.model.BpmPrintRecord;
import com.artfess.workflow.runtime.params.BpmPrintRecordObject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;

/**
 * 
 * <pre> 
 * 描述：流程打印文件管理表 处理实现类
 * 构建组：x7
 * 作者:zhangxw
 * 邮箱:zhangxw@jee-soft.cn
 * 日期:2020-05-23 19:58:35
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@Service("bpmPrintRecordManager")
public class BpmPrintRecordManagerImpl extends BaseManagerImpl<BpmPrintRecordDao, BpmPrintRecord> implements BpmPrintRecordManager{

	@Override
	public BpmPrintRecord getLastVersion(String procInstId, String nodeId,
			String templateId) {
		return baseMapper.getLastVersion(procInstId, nodeId, templateId);
	}

	@Override
	public void cleanLastVersion(String procInstId, String nodeId,
			String templateId) {
		baseMapper.cleanLastVersion(procInstId, nodeId, templateId);
	}

	@Override
	@Transactional
	public CommonResult<String> addPrintLog(BpmPrintRecordObject printRecordObject) {
		try {
			BpmPrintRecord newRecord = JsonUtil.toBean(JsonUtil.toJson(printRecordObject), BpmPrintRecord.class);
			newRecord.setId(UniqueIdUtil.getSuid());
			//清除旧的最新版本
			baseMapper.cleanLastVersion(newRecord.getProcInstId(), newRecord.getNodeId(), newRecord.getTemplateId());
			newRecord.setLastVersion(1);
			super.save(newRecord);
		} catch (IOException e) {
			return new CommonResult<String>(false,"新增打印记录失败："+e.getMessage());
		}
		return new CommonResult<String>(false,"新增打印记录成功。");
	}
	
}
