package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.dao.TenantTypeDao;
import com.artfess.uc.manager.TenantManageManager;
import com.artfess.uc.manager.TenantTypeManager;
import com.artfess.uc.model.TenantType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 *
 * <pre>
 * 描述：租户类型管理 处理实现类
 * 构建组：x7
 * 作者:zhangxw
 * 邮箱:zhangxw@jee-soft.cn
 * 日期:2020-04-17 10:52:37
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@Service("tenantTypeManager")
public class TenantTypeManagerImpl extends BaseManagerImpl<TenantTypeDao, TenantType> implements TenantTypeManager{

	@Resource
	TenantManageManager tenantManageManager;

	@Override
	public List<TenantType> getByStatus(String status,List<String> authIds) {
		return baseMapper.getByStatus(status,BeanUtils.isNotEmpty(authIds)?authIds:null);
	}

	@Override
	public TenantType getByCode(String code) {
		return baseMapper.getByCode(code);
	}

	@Override
	public TenantType getDefault() {
		return baseMapper.getDefault();
	}

	@Override
	@Transactional
	public CommonResult<String> setDefault(String code) {
		TenantType type = baseMapper.getByCode(code);
		if(BeanUtils.isNotEmpty(type)){
			baseMapper.setNotDefault();
			type.setIsDefault("1");
			super.update(type);
			return new CommonResult<String>(true,"设置成功！");
		}else{
			return new CommonResult<String>(false,"租户类型编码【"+code+"】不存在！");
		}
	}
}
