package com.artfess.uc.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.uc.manager.ResouceManager;
import com.artfess.uc.model.Resouce;
import com.artfess.uc.params.resouce.ResouceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 维度模块接口
 * @author zhangxw
 *
 */
@RestController
@RequestMapping("/api/resouce/v1/")
@Api(tags="角色资源关系")
@ApiGroup(group= {ApiGroupConsts.GROUP_UC})
public class ResouceController extends BaseController<ResouceManager, Resouce> {
	
	@Resource
	ResouceManager resouceService;

	/**
	 * 添加维度
	 * @param dem
	 * @return
	 * @throws Exception
	 * 
	 */
	@RequestMapping(value="resouce/saveResouce",method=RequestMethod.POST, produces = {
	"application/json; charset=utf-8" })
	@ApiOperation(value = "添加角色资源关系", httpMethod = "POST", notes = "添加角色资源关系")
	public CommonResult<String> saveResouce(@ApiParam(name="resouceVo",value="维度参数对象", required = true) @RequestBody ResouceVo resouceVo) throws Exception{
		return resouceService.saveResouce(resouceVo);
	}
	
	/**
	 * 添加维度
	 * @param dem
	 * @return
	 * @throws Exception
	 * 
	 */
	@RequestMapping(value="resouce/getByRoleCode",method=RequestMethod.GET, produces = {
	"application/json; charset=utf-8" })
	@ApiOperation(value = "根据角色获取资源信息", httpMethod = "GET", notes = "根据角色获取资源信息")
	public Resouce getByRoleCode(@ApiParam(name="roleCode",value="角色编码", required = true)  String roleCode) throws Exception{
		return resouceService.getByRoleCode(roleCode);
	}
}
