package com.artfess.file.attachmentService;

import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.config.HwObsSetting;
import com.artfess.file.model.FileStorage;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.manager.FileStorageManager;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import com.artfess.file.util.HuaweiyunOssUtil;
import org.springframework.stereotype.Service;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;

/**
 * @program: edp
 * @Date: 2021/3/22 16:19
 * @Author: llj
 * @Description:
 */
@Service
public class HuaweiyunObsAttachmentServiceImpl implements AttachmentService {
    @Override
    public String getStoreType() {
        return "huaweiObs";
    }

    private HwObsSetting initMinioSettings(Attachment attachment, String propertiesId) {
        HwObsSetting ossSettings = AppUtil.getBean(HwObsSetting.class);
        if (StringUtil.isNotEmpty(propertiesId)) {
            FileStorageManager fileStorageManager = AppUtil.getBean(FileStorageManager.class);
            FileStorage fileStorage = fileStorageManager.get(propertiesId);
            if (BeanUtils.isNotEmpty(fileStorage)) {
                ossSettings.setAk(fileStorage.getUserName());
                ossSettings.setSk(fileStorage.getPassword());
                ossSettings.setEndpoint(fileStorage.getEndpoint());
                ossSettings.setBucketName(fileStorage.getLocation());
                attachment.setEntryptName(fileStorage.getEncryptName() == 0 ? false : true);
            }
        }else{
            FlowUploadPropertiesManager uploadPropertiesManager = AppUtil.getBean(FlowUploadPropertiesManager.class);
            FlowUploadPropertiesStorageDTO uploadProperties = uploadPropertiesManager.getById(propertiesId);
            if (BeanUtils.isNotEmpty(uploadProperties)) {
                ossSettings.setAk(uploadProperties.getAccessKeyId());
                ossSettings.setSk(uploadProperties.getAccessKeySecret());
                ossSettings.setEndpoint(uploadProperties.getEndpoint());
                ossSettings.setBucketName(uploadProperties.getLocation());
                attachment.setEntryptName(uploadProperties.getEncryptName() == 0 ? false : true);
            }
        }
        HuaweiyunOssUtil.setAk(ossSettings.getAk());
        HuaweiyunOssUtil.setSk(ossSettings.getSk());
        HuaweiyunOssUtil.setEndpoint(ossSettings.getEndpoint());
        HuaweiyunOssUtil.setBucketName(ossSettings.getBucketName());
        return ossSettings;
    }

    @Override
    public void remove(Attachment attachment, String propertiesId) throws Exception {
        String fileParentPath = "";
        String filePath = attachment.getFilePath();
        if (StringUtil.isNotEmpty(filePath)) {
            fileParentPath = Paths.get(filePath).getParent().toString();
            fileParentPath = fileParentPath.replaceAll("\\\\", "/");
            if (fileParentPath.startsWith("/")) {
                fileParentPath = fileParentPath.substring(1);
            }
        }
        String fileName = fileParentPath + "/" + attachment.getId() + "." + attachment.getExtensionName();
        initMinioSettings(attachment,propertiesId);
        HuaweiyunOssUtil.deleteFile(fileName);
    }

    @Override
    public void upload(Attachment attachment, InputStream inputStream, String propertiesId) throws Exception {
        String fileParentPath = "";
        String filePath = attachment.getFilePath();
        if (StringUtil.isNotEmpty(filePath)) {
            fileParentPath = Paths.get(filePath).getParent().toString();
            fileParentPath = fileParentPath.replaceAll("\\\\", "/");
            if (fileParentPath.startsWith("/")) {
                fileParentPath = fileParentPath.substring(1);
            }
        }
        String fileName = fileParentPath + "/" + attachment.getId() + "." + attachment.getExtensionName();
        initMinioSettings(attachment,propertiesId);
        HuaweiyunOssUtil.uploadFile(fileName, inputStream);

    }

    @Override
    public void download(Attachment attachment, OutputStream outStream, String propertiesId) throws Exception {
        String fileParentPath = "";
        String filePath = attachment.getFilePath();
        if (StringUtil.isNotEmpty(filePath)) {
            fileParentPath = Paths.get(filePath).getParent().toString();
            fileParentPath = fileParentPath.replaceAll("\\\\", "/");
            if (fileParentPath.startsWith("/")) {
                fileParentPath = fileParentPath.substring(1);
            }
        }
        String fileName = fileParentPath + "/" + attachment.getId() + "." + attachment.getExtensionName();
        initMinioSettings(attachment,propertiesId);
        HuaweiyunOssUtil.Download(fileName, outStream);
    }

    @Override
    public boolean chekckFile(Attachment attachment, String propertiesId) throws Exception {
        initMinioSettings(attachment,propertiesId);
        boolean b = HuaweiyunOssUtil.chekckFile(attachment.getFileName());
        return b;
    }

    @Override
    public byte[] getFileBytes(Attachment sysFile) throws Exception {
        return new byte[0];
    }

    @Override
    public String initMultiPartUpload(Attachment attachment) {
        return null;
    }

    @Override
    public String getChunkUrl(Attachment attachment, Integer partNumber, String uploadId) {
        return null;
    }

    @Override
    public boolean mergeMultipartUpload(Attachment attachment, String uploadId, int realyPartNumber) {
        return false;
    }
}
