package com.artfess.bpm.persistence.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import java.util.Arrays;
import java.util.List;

@XmlRootElement(name = "bpmReportAct")
@XmlAccessorType(XmlAccessType.FIELD)
@TableName("bpm_report_act")
public class BpmReportAct extends BaseModel<BpmReportAct>{

	/**
	 *
	 */
	private static final long serialVersionUID = -3177931239826935082L;

	//主键
	@XmlTransient
	@TableId("id_")
	protected String id;

	//报表主表id
	@XmlTransient
	@TableField("report_id_")
	protected String reportId;

	//流程id
	@XmlTransient
	@TableField("bpm_def_id_")
	protected String bpmDefId;

	//报表名称(流程名称)
	@XmlAttribute(name = "reportName")
	@TableField("report_name_")
	protected String reportName;

	//组织维度
	@XmlTransient
	@TableField("dimension_id_")
	protected String dimensionId;

	//统计级别
	@XmlAttribute(name = "grade")
	@TableField("grade_")
	protected String grade;

	//统计参数
	@XmlAttribute(name = "params")
	@TableField("params_")
	protected String params;

	//报表x轴数据(存入数据库)
	@XmlAttribute(name = "xAxis")
	@TableField("x_axis_")
	protected String xAxis;

	//报表y轴数据(存入数据库)
	@XmlAttribute(name = "yAxis")
	@TableField("y_axis_")
	protected String yAxis;

	//授权视图内容
	@XmlAttribute(name = "rightContent")
	@TableField("right_content_")
	protected String rightContent;

	//默认显示视图
	@XmlAttribute(name = "isDefault")
	@TableField("is_default_")
	protected String isDefault;

	//设置参数
	@XmlAttribute(name = "porp")
	@TableField("porp_")
	protected String porp;

	//传入前台x轴数据
	@XmlAttribute(name = "xData")
	@TableField(exist=false)
	protected String[] xData;

	//传入前台y轴数据
	@XmlAttribute(name = "yData")
	@TableField(exist=false)
	protected String[] yData;

	@XmlAttribute(name = "flowTypeKeys")
	@TableField(exist=false)
	@ApiModelProperty(value="流程分类Keys 该字段仅用于数据导入导出")
	protected List<String> flowTypeKeys;

	@XmlAttribute(name = "orgCodes")
	@TableField(exist=false)
	@ApiModelProperty(value="组织编码 该字段仅用于数据导入导出")
	protected List<String> orgCodes;

	@XmlAttribute(name = "userAccounts")
	@TableField(exist=false)
	@ApiModelProperty(value="用户账号 该字段仅用于数据导入导出")
	protected List<String> userAccounts;

	public BpmReportAct() {

	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getReportId() {
		return reportId;
	}

	public void setReportId(String reportId) {
		this.reportId = reportId;
	}

	public String getPorp() {
		return porp;
	}

	public void setPorp(String porp) {
		this.porp = porp;
	}

	public String getBpmDefId() {
		return bpmDefId;
	}

	public void setBpmDefId(String bpmDefId) {
		this.bpmDefId = bpmDefId;
	}

	public String getReportName() {
		return reportName;
	}

	public void setReportName(String reportName) {
		this.reportName = reportName;
	}

	public String getDimensionId() {
		return dimensionId;
	}

	public void setDimensionId(String dimensionId) {
		this.dimensionId = dimensionId;
	}

	public String getParams() {
		return params;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public String getxAxis() {
		return xAxis;
	}

	public void setxAxis(String xAxis) {
		this.xAxis = xAxis;
	}

	public String getyAxis() {
		return yAxis;
	}

	public void setyAxis(String yAxis) {
		this.yAxis = yAxis;
	}

	public String getRightContent() {
		return rightContent;
	}

	public void setRightContent(String rightContent) {
		this.rightContent = rightContent;
	}

	public String getIsDefault() {
		return isDefault;
	}

	public void setIsDefault(String isDefault) {
		this.isDefault = isDefault;
	}

	public String[] getxData() {
		return xData;
	}

	public void setxData(String[] xData) {
		this.xData = xData;
	}

	public String[] getyData() {
		return yData;
	}

	public void setyData(String[] yData) {
		this.yData = yData;
	}

	public String getGrade() {
		return grade;
	}

	public void setGrade(String grade) {
		this.grade = grade;
	}

	public List<String> getFlowTypeKeys() {
		return flowTypeKeys;
	}

	public void setFlowTypeKeys(List<String> flowTypeKeys) {
		this.flowTypeKeys = flowTypeKeys;
	}

	public List<String> getOrgCodes() {
		return orgCodes;
	}

	public void setOrgCodes(List<String> orgCodes) {
		this.orgCodes = orgCodes;
	}

	public List<String> getUserAccounts() {
		return userAccounts;
	}

	public void setUserAccounts(List<String> userAccounts) {
		this.userAccounts = userAccounts;
	}

	@Override
	public String toString() {
		return "BpmReportAct{" +
				"id='" + id + '\'' +
				", reportId='" + reportId + '\'' +
				", bpmDefId='" + bpmDefId + '\'' +
				", reportName='" + reportName + '\'' +
				", dimensionId='" + dimensionId + '\'' +
				", grade='" + grade + '\'' +
				", params='" + params + '\'' +
				", xAxis='" + xAxis + '\'' +
				", yAxis='" + yAxis + '\'' +
				", rightContent='" + rightContent + '\'' +
				", isDefault='" + isDefault + '\'' +
				", porp='" + porp + '\'' +
				", xData=" + Arrays.toString(xData) +
				", yData=" + Arrays.toString(yData) +
				'}';
	}
}
