package com.artfess.portal.service.impl;

import com.artfess.base.constants.TenantConstant;
import com.artfess.base.util.TenantUtil;
import com.artfess.portal.service.TenantService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <pre>
 * @author zhaoxy
 * @company 阿特菲斯信息技术有限公司
 * @email zhxy@jee-soft.cn
 * @date 2018-06-06 14:20
 * </pre>
 */
@Service
public class TenantServiceImpl implements TenantService {

    private Log logger = LogFactory.getLog(TenantServiceImpl.class);

    @Override
    public void initData(String tenantId) {
        logger.debug("开始初始化租户的数据");
        List<String> tableNames = TenantConstant.INIT_PORTAL_DATA_TABLE_NAMES;
        TenantUtil.initData(tenantId, tableNames);
    }

}
