package com.artfess.base.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 *
 * <pre>
 * 在Controller类上添加该注解，表示该接口需要同步
 * </pre>
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @date 2024年11月19日
 */
@Inherited
@Documented
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface SyncAnnotation {
    String httpMethod() default "";
}
