package com.artfess.application.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.persistence.manager.SysLoginLogsManager;
import com.artfess.sysConfig.persistence.model.SysLoginLogs;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <pre>
 * 描述：系统登录日志 控制器类
 * 构建组：artfess
 * 作者:baseli
 * 日期:2021年6月9日15:46:28
 * </pre>
 */
@RestController
@RequestMapping(value = "/logs/sysLoginLogs/v1")
@Api(tags = "系统登录日志")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
public class SysLoginLogsController extends BaseController<SysLoginLogsManager, SysLoginLogs> {
    @Resource
    SysLoginLogsManager sysLoginLogsManager;

    /**
     * 系统登录日志列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/list")
    @ApiOperation(value = "系统登录日志数据列表", httpMethod = "POST", notes = "获取系统登录日志列表")
    public PageList<SysLoginLogs> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<SysLoginLogs> queryFilter) throws Exception {
        return sysLoginLogsManager.query(queryFilter);
    }

    /**
     * 系统登录日志明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "根据ID查询系统登录日志", httpMethod = "POST", notes = "根据ID查询系统登录日志")
    public SysLoginLogs get(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        return sysLoginLogsManager.get(id);
    }

    /**
     * 新增系统登录日志
     *
     * @param sysLoginLogs
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "save")
    @ApiOperation(value = "添加/修改系统登录日志", httpMethod = "POST", notes = "添加/修改系统登录日志")
    public CommonResult<String> save(@ApiParam(name = "sysLoginLogs", value = "添加/修改系统登录日志", required = true) @RequestBody SysLoginLogs sysLoginLogs) throws Exception {
        String msg = "添加系统登录日志成功";
        if (StringUtil.isEmpty(sysLoginLogs.getId())) {
            sysLoginLogsManager.create(sysLoginLogs);
        } else {
            sysLoginLogsManager.update(sysLoginLogs);
            msg = "更新系统登录日志成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 删除系统登录日志记录
     *
     * @param id
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "remove/{id}")
    @ApiOperation(value = "根据ID删除系统登录日志", httpMethod = "POST", notes = "根据ID删除系统登录日志")
    public CommonResult<String> remove(@ApiParam(name = "id", value = "业务主键", required = true) @PathVariable String id) throws Exception {
        sysLoginLogsManager.remove(id);
        return new CommonResult<String>(true, "删除成功");
    }

    /**
     * 批量删除系统登录日志记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "根据ID批量删除系统登录日志", httpMethod = "POST", notes = "根据ID批量删除系统登录日志")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "业务主键数组,多个业务主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        sysLoginLogsManager.removeByIds(ids);
        return new CommonResult<String>(true, "删除成功");
    }

}
