package com.artfess.data.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 基站数据导入
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-11-14
 */
@ApiModel(value="BizDataImport对象", description="基站数据导入")
public class BizDataImport extends BaseModel<BizDataImport> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据编号")
    @TableField("export_code_")
    private String exportCode;

    @ApiModelProperty(value = "上报截止日期")
    @TableField("expiration_time_")
    private LocalDateTime expirationTime;

    @ApiModelProperty(value = "导入单位id")
    @TableField("org_id_")
    private String orgId;

    @ApiModelProperty(value = "导入单位")
    @TableField("org_name_")
    private String orgName;

    @ApiModelProperty(value = "导入状态")
    @TableField("status_")
    private String status;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "删除标识【字典】（0：未删除，1：已删除）")
    @TableField("is_dele_")
    private String isDele;

    @ApiModelProperty(value = "创建人")
    @TableField("create_by_")
    private String createBy;

    @ApiModelProperty(value = "创建人_组织_ID")
    @TableField("create_org_id_")
    private String createOrgId;

    @ApiModelProperty(value = "创建时间")
    @TableField("create_time_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改人组织ID")
    @TableField("update_org_id_")
    private String updateOrgId;

    @ApiModelProperty(value = "修改人员")
    @TableField("update_by_")
    private String updateBy;

    @ApiModelProperty(value = "修改时间")
    @TableField("update_time_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getExportCode() {
        return exportCode;
    }

    public void setExportCode(String exportCode) {
        this.exportCode = exportCode;
    }

    public LocalDateTime getExpirationTime() {
        return expirationTime;
    }

    public void setExpirationTime(LocalDateTime expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getUpdateOrgId() {
        return updateOrgId;
    }

    public void setUpdateOrgId(String updateOrgId) {
        this.updateOrgId = updateOrgId;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public LocalDateTime getLastTime() {
        return lastTime;
    }

    public void setLastTime(LocalDateTime lastTime) {
        this.lastTime = lastTime;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizDataImport{" +
            "id=" + id +
            ", exportCode=" + exportCode +
            ", expirationTime=" + expirationTime +
            ", orgId=" + orgId +
            ", orgName=" + orgName +
            ", status=" + status +
            ", memo=" + memo +
            ", sn=" + sn +
            ", isDele=" + isDele +
            ", createBy=" + createBy +
            ", createOrgId=" + createOrgId +
            ", createTime=" + createTime +
            ", updateOrgId=" + updateOrgId +
            ", updateBy=" + updateBy +
            ", updateTime=" + updateTime +
            ", lastTime=" + lastTime +
        "}";
    }
}
