package com.artfess.data.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.data.dao.BizSubjectBaseDataDao;
import com.artfess.data.manager.BizSubjectBaseDataManager;
import com.artfess.data.model.BizSubjectBaseData;
import com.artfess.examine.manager.ExamSubjectInfoManager;
import com.artfess.examine.model.ExamSubjectInfo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 课目训练基础数据 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Service
public class BizSubjectBaseDataManagerImpl extends BaseManagerImpl<BizSubjectBaseDataDao, BizSubjectBaseData> implements BizSubjectBaseDataManager {

    @Autowired
    private ExamSubjectInfoManager subjectInfoManager;

    @Override
    public void importList(List<BizSubjectBaseData> list) {
        QueryWrapper<ExamSubjectInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        List<ExamSubjectInfo> subjectInfos = subjectInfoManager.list(queryWrapper);
        Map<String, ExamSubjectInfo> subjectInfoMap = subjectInfos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(baseData -> {
            if(CollectionUtils.isEmpty(subjectInfoMap)) {
                return;
            }
            if(null == subjectInfoMap.get(baseData.getSubjectName())) {
                baseData.setSubjectId(baseData.getId());
            }
        });
        this.saveBatch(list);
    }
}
