package com.artfess.data.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.data.dao.BizEquipmentOperationDataDao;
import com.artfess.data.manager.BizEquipmentOperationDataManager;
import com.artfess.data.model.BizEquipmentOperationData;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.vo.OrgVo;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 装备运行数据 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Service
public class BizEquipmentOperationDataManagerImpl extends BaseManagerImpl<BizEquipmentOperationDataDao, BizEquipmentOperationData> implements BizEquipmentOperationDataManager {

    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;

    @Transactional
    @Override
    public void saveList(List<BizEquipmentOperationData> list) {
        List<OrgVo> orgVos = orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(data -> {
            Assert.hasText(data.getOrgName(), "请填写单位");
            if (!CollectionUtils.isEmpty(orgMap) && null != orgMap.get(data.getOrgName())) {
                data.setOrgId(orgMap.get(data.getOrgName()).getId());
            }
        });
        this.saveBatch(list);
    }
}
