package com.artfess.examine.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.examine.manager.ExamYearReportManager;
import com.artfess.examine.model.ExamYearReport;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 年度上报记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-12-07
 */
@Slf4j
@RestController
@Api(tags = "基础数据-年度上报")
@RequestMapping("/exam/year/report/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ExamYearReportController extends BaseController<ExamYearReportManager, ExamYearReport> {

}
