package com.artfess.examine.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.examine.manager.ExamOrgEvaluationManager;
import com.artfess.examine.model.ExamOrgEvaluation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 年度组织综合评定表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-08-21
 */
@Slf4j
@RestController
@Api(tags = "成绩管理-分队年度成绩")
@RequestMapping("/exam/org/evaluation/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ExamOrgEvaluationController extends BaseController<ExamOrgEvaluationManager, ExamOrgEvaluation> {

    @GetMapping("createOrgEvaluation")
    @ApiOperation("计算组织年度得分")
    public void createOrgEvaluation() {
        baseService.createOrgEvaluation();
    }

}
