package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 装备基础资源数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@ApiModel(value="BizEquipmentBaseData对象", description="装备基础资源数据")
public class BizEquipmentBaseData extends AutoFillModel<BizEquipmentBaseData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @Excel(name = "装备分类", column = "A")
    @ApiModelProperty(value = "装备分类【字典】")
    @TableField("type_")
    private String type;

    @Excel(name = "装备名称", column = "B")
    @ApiModelProperty(value = "装备名称")
    @TableField("name_")
    private String name;

    @Excel(name = "出厂编号", column = "C")
    @ApiModelProperty(value = "出厂编号")
    @TableField("mf_code_")
    private String mfCode;

    @Excel(name = "责任人", column = "H")
    @ApiModelProperty(value = "责任人")
    @TableField("person_liable_")
    private String personLiable;

    @ApiModelProperty(value = "责任人id")
    @TableField("person_liable_id_")
    private String personLiableId;

    @Excel(name = "战斗编号", column = "D")
    @ApiModelProperty(value = "战斗编号")
    @TableField("battle_code_")
    private String battleCode;

    @NotNull(message = "请选择所属单位", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "所属单位id")
    @TableField("org_id_")
    private String orgId;

    @Excel(name = "所属单位", column = "E")
    @ApiModelProperty(value = "所属单位")
    @TableField("org_name_")
    private String orgName;

    @Excel(name = "列装时间", column = "G")
    @ApiModelProperty(value = "列装时间")
    @TableField("loading_time_")
    private LocalDate loadingTime;

    @Excel(name = "计量单位", column = "H")
    @ApiModelProperty(value = "计量单位【字典】")
    @TableField("unit_")
    private String unit;

    @Excel(name = "战教区分", column = "I")
    @ApiModelProperty(value = "战教区分")
    @TableField("zjqf_")
    private String zjqf;

    @Excel(name = "装备状态", column = "J")
    @ApiModelProperty(value = "装备状态【字典】（1：值班、2：维修、3：闲置）")
    @TableField("status_")
    private String status;

    @Excel(name = "备注", column = "K")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;
}
