/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.DictionaryUtils;
import com.artfess.data.manager.BizExamSpaceDataManager;
import com.artfess.data.model.BizExamSpaceData;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u8bad\u7ec3\u6570\u636e-\u8bad\u7ec3\u573a\u5730\u6570\u636e"})
@RequestMapping(value={"/biz/examSpace/data/"})
@ApiGroup(group={"group_biz"})
public class BizExamSpaceDataController
extends BaseController<BizExamSpaceDataManager, BizExamSpaceData> {
    private static final Logger log = LoggerFactory.getLogger(BizExamSpaceDataController.class);

    @ApiOperation(value="\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file) {
        try {
            ExcelUtils excelUtil = new ExcelUtils(BizExamSpaceData.class);
            List list = excelUtil.importExcel(null, file.getInputStream());
            ((BizExamSpaceDataManager)this.baseService).saveList(list);
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25," + e.getMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizExamSpaceData> queryFilter) throws Exception {
        PageList page = ((BizExamSpaceDataManager)this.baseService).query(queryFilter);
        page.getRows().forEach(data -> {
            if (null != DictionaryUtils.findByDictValue((String)"cdlx", (String)data.getType())) {
                String type = DictionaryUtils.findByDictValue((String)"cdlx", (String)data.getType()).getName();
                data.setType(type);
            }
        });
        ExcelUtils util = new ExcelUtils(BizExamSpaceData.class);
        util.exportExcel(response, request, page.getRows(), "\u8bad\u7ec3\u573a\u5730\u6570\u636e");
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/downModel"})
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/\u8bad\u7ec3\u4fdd\u969c\u6570\u636e/\u8bad\u7ec3\u573a\u5730\u6570\u636e.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u8bad\u7ec3\u573a\u5730\u6570\u636e\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }
}

