package com.artfess.file.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.FileStorage;
import com.artfess.file.persistence.manager.FileStorageManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <pre>
 * 描述：系统附件存储配置 控制器类
 * 作者:zhangxw
 * </pre>
 */
@RestController
@RequestMapping(value = "/file/fileStorage/v1")
@Api(tags = "系统附件存储配置")
@ApiGroup(group = {ApiGroupConsts.GROUP_SYSTEM})
public class FileStorageController extends BaseController<FileStorageManager, FileStorage> {
    @Resource
    FileStorageManager fileStorageManager;

    @PostMapping("/listJson")
    @ApiOperation(value = "系统附件存储配置列表", httpMethod = "POST", notes = "获取系统附件存储配置列表")
    public PageList<FileStorage> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter queryFilter) throws Exception {
        return fileStorageManager.query(queryFilter);
    }

    @RequestMapping(value = "listNoPage", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "系统附件存储配置列表(不分页)", httpMethod = "POST", notes = "系统附件存储配置列表(不分页)")
    public PageList<FileStorage> listJsonNoPage(@ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter<FileStorage> queryFilter) throws Exception {
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<FileStorage> fileStorageList = fileStorageManager.query(queryFilter);
        return fileStorageList;
    }

    /**
     * 系统附件存储配置明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/getJson")
    @ApiOperation(value = "系统附件存储配置数据详情", httpMethod = "GET", notes = "系统附件存储配置数据详情")
    public FileStorage get(@ApiParam(name = "id", value = "系统附件存储配置业务对象主键", required = true) @RequestParam String id) throws Exception {
        return fileStorageManager.get(id);
    }

    /**
     * 新增系统附件存储配置
     *
     * @param fileStorage
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "save")
    @ApiOperation(value = "新增,更新系统附件存储配置数据", httpMethod = "POST", notes = "新增,更新流程附件上传配置数据")
    public CommonResult<String> save(@ApiParam(name = "fileStorage", value = "系统附件存储配置业务对象", required = true) @RequestBody FileStorage fileStorage) throws Exception {
        String msg = "添加系统附件存储配置成功";
        if (StringUtil.isEmpty(fileStorage.getId())) {
            fileStorageManager.insertFileStorage(fileStorage);
        } else {
            fileStorageManager.updateFileStorage(fileStorage);
            msg = "更新系统附件存储配置成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 批量删除系统附件存储配置记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove")
    @ApiOperation(value = "批量删除系统附件存储配置记录", httpMethod = "DELETE", notes = "批量删除系统附件存储配置记录")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "业务主键数组,多个业务主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        String msg = fileStorageManager.deleteFileStorage(ids);
        return new CommonResult<String>(true, msg);
    }

}
