/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.enums;

import cn.hutool.core.util.NumberUtil;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public enum ScoreLevelEnum {
    GOOD(1, new BigDecimal(90), new BigDecimal(100), "\u4f18\u79c0"),
    LH(2, new BigDecimal(70), new BigDecimal(89), "\u826f\u597d"),
    JG(3, new BigDecimal(60), new BigDecimal(69), "\u53ca\u683c"),
    BJG(4, new BigDecimal(0), new BigDecimal(59), "\u4e0d\u53ca\u683c");

    private Integer type;
    private BigDecimal min;
    private BigDecimal max;
    private String desc;

    private ScoreLevelEnum(Integer type, BigDecimal min, BigDecimal max, String desc) {
        this.type = type;
        this.desc = desc;
        this.min = min;
        this.max = max;
    }

    public static Integer getLevel(BigDecimal score) {
        ScoreLevelEnum[] values;
        if (null == score) {
            return null;
        }
        for (ScoreLevelEnum state : values = ScoreLevelEnum.values()) {
            if (!NumberUtil.isGreaterOrEqual((BigDecimal)score, (BigDecimal)state.getMin()) || !NumberUtil.isLessOrEqual((BigDecimal)score, (BigDecimal)state.getMax())) continue;
            return state.type;
        }
        return null;
    }

    public static String getDesc(Integer type) {
        ScoreLevelEnum[] values;
        if (null == type) {
            return null;
        }
        for (ScoreLevelEnum state : values = ScoreLevelEnum.values()) {
            if (!state.getType().equals(type)) continue;
            return state.getDesc();
        }
        return null;
    }

    public static Integer getType(String desc) {
        ScoreLevelEnum[] values;
        if (!StringUtils.isNotEmpty((CharSequence)desc)) {
            return null;
        }
        for (ScoreLevelEnum state : values = ScoreLevelEnum.values()) {
            if (!state.getDesc().equals(desc)) continue;
            return state.getType();
        }
        return null;
    }

    public static void main(String[] args) {
        Integer level = ScoreLevelEnum.getLevel(new BigDecimal(79));
        System.out.println(level);
    }

    public Integer getType() {
        return this.type;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public String getDesc() {
        return this.desc;
    }
}

