package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 训练类别
 */
@Getter
public enum TrainLevelEnum {
    cj("1", "初级"),

    zj("2", "中级"),

    gj("3", "高级"),

    ;

    TrainLevelEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        TrainLevelEnum[] values = values();
        for (TrainLevelEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        TrainLevelEnum[] values = values();
        for (TrainLevelEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
