package com.artfess.base.enums;

import cn.hutool.core.util.NumberUtil;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * 评分等级
 */
@Getter
public enum ScoreLevelEnum {
    /**
     * 等级
     */
    GOOD(1, new BigDecimal(90), new BigDecimal(100),"优秀"),

    LH(2, new BigDecimal(70), new BigDecimal(89),"良好"),

    JG(3, new BigDecimal(60), new BigDecimal(69),"及格"),

    BJG(4, new BigDecimal(0), new BigDecimal(59),"不及格"),

    ;

    ScoreLevelEnum(Integer type, BigDecimal min, BigDecimal max, String desc){
        this.type = type;
        this.desc = desc;
        this.min = min;
        this.max = max;
    }

    private Integer type;

    private BigDecimal min;

    private BigDecimal max;

    private String desc;

    public static Integer getLevel(BigDecimal score) {

        if(null == score){
            return null;
        }
        ScoreLevelEnum[] values = values();
        for (ScoreLevelEnum state : values) {
            if(NumberUtil.isGreaterOrEqual(score, state.getMin()) && NumberUtil.isLessOrEqual(score, state.getMax())) {
                return state.type;
            }
        }
        return null;
    }

    public static String getDesc(Integer type){
        if(null == type){
            return null;
        }
        ScoreLevelEnum[] values = values();
        for (ScoreLevelEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }

    public static Integer getType(String desc){
        if(!StringUtils.isNotEmpty(desc)){
            return null;
        }
        ScoreLevelEnum[] values = values();
        for (ScoreLevelEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        Integer level = getLevel(new BigDecimal(79));
        System.out.println(level);
    }
}
