package com.artfess.base.attachment;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * 附件管理接口
 * @company 阿特菲斯信息技术有限公司
 * @author:lj
 * @date:2018年6月13日
 */
public interface AttachmentService {

	/**
	 * 获取附件处理器类型
	 * @return
	 */
	String getStoreType();

	/**
	 * 删除附件
	 * @param attachment
	 * @param propertiesId
	 * @throws Exception
	 */
	void remove(Attachment attachment,String propertiesId) throws Exception;
	/**
	 * 上传附件
	 * @param attachment
	 * @param inputStream
	 * @param propertiesId
	 * @throws Exception
	 */
	void upload(Attachment attachment, InputStream inputStream,String propertiesId) throws Exception;
	/**
	 * 下载附件
	 * @param attachment
	 * @param outStream
	 * @param propertiesId
	 * @throws Exception
	 */
	void download(Attachment attachment, OutputStream outStream,String propertiesId) throws Exception;


	/**
	 * 判断附件是否存在
	 * @param attachment
	 * @return
	 */
	boolean chekckFile(Attachment attachment,String propertiesId) throws Exception;

	byte[] getFileBytes(Attachment sysFile) throws Exception;

	String initMultiPartUpload(Attachment attachment);

	String getChunkUrl(Attachment attachment, Integer partNumber, String uploadId);

	/**
	 * 分片文件上传Id, 上传成果分片数量
	 * @param uploadId
	 * @param realyPartNumber
	 * @return
	 */
	boolean mergeMultipartUpload(Attachment attachment,String uploadId, int realyPartNumber);
}
