package com.artfess.base.context;

import java.util.List;

/**
 * 当前登录用户的上下文数据
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2020年4月9日
 */
public interface BaseContext {
	/**
	 * 获取当前登录用户ID
	 * @return
	 */
	String getCurrentUserId();

	/**
	 * 获取当前登录用户账号
	 * @return
	 */
	String getCurrentUserAccout();

	/**
	 * 获取当前登录用户账号
	 * @return
	 */
	String getCurrentUserName();

	/**
	 * 获取当前登录用户所属组织ID
	 * @return
	 */
	String getCurrentOrgId();

	/**
	 * 获取当前登录用户组织和下级组织
	 * @return
	 */
	List<String> getCurrentAndChildOrgIds();

	/**
	 * 获取当前登录用户所属组织name
	 * @return
	 */
	String getCurrentOrgName();

	/**
	 * 获取当前登录用户所属部门ID
	 * @return
	 */
	String getCurrentDeptId();

	/**
	 * 获取当前登录用户所属部门name
	 * @return
	 */
	String getCurrentDeptName();

	/**
	 * 获取当前登录用户所在租户ID
	 * @return
	 */
	String getCurrentTenantId();
	/**
	 * 设置当前租户ID
	 * @param tenantId
	 */
    void setTempTenantId(String tenantId);
    /**
     * 清空当前租户ID
     */
    void clearTempTenantId();
}
