/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.sysConfig.persistence.dao.SysModuleDao;
import com.artfess.sysConfig.persistence.manager.SysModuleDetailManager;
import com.artfess.sysConfig.persistence.manager.SysModuleManager;
import com.artfess.sysConfig.persistence.model.SysModule;
import com.artfess.sysConfig.persistence.model.SysModuleDetail;
import com.artfess.sysConfig.persistence.param.SysModuleImportXml;
import com.artfess.sysConfig.persistence.param.SysModuleXml;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import org.springframework.stereotype.Service;

@Service
public class SysModuleManagerImpl
extends BaseManagerImpl<SysModuleDao, SysModule>
implements SysModuleManager {
    @Resource
    SysModuleDetailManager sysModuleDetailManager;

    public void remove(Serializable id) {
        super.remove(id);
        this.sysModuleDetailManager.removeByModuleId(id);
    }

    public void removeByIds(String ... ids) {
        if (ids != null) {
            for (String pk : ids) {
                this.remove((Serializable)((Object)pk));
            }
        }
    }

    @Override
    public void saveModule(SysModule sysModule) {
        String id = sysModule.getId();
        IUser user = ContextUtil.getCurrentUser();
        if (BeanUtils.isNotEmpty((Object)user)) {
            sysModule.setCreateBy(user.getUserId());
            sysModule.setCreator(user.getFullname());
        } else {
            sysModule.setCreator("\u7cfb\u7edf");
        }
        if (StringUtil.isEmpty((String)id)) {
            sysModule.setId(UniqueIdUtil.getSuid());
            sysModule.setUpdateTime(LocalDateTime.now());
            this.create((Model)sysModule);
        } else {
            this.update((Model)sysModule);
            this.sysModuleDetailManager.removeByModuleId((Serializable)((Object)sysModule.getId()));
        }
        List<SysModuleDetail> details = sysModule.getModuleDetail();
        if (BeanUtils.isNotEmpty(details)) {
            for (int x = 0; x < details.size(); ++x) {
                SysModuleDetail sysModuleDetail = details.get(x);
                sysModuleDetail.setSn(x);
                if (StringUtil.isEmpty((String)sysModuleDetail.getId())) {
                    sysModuleDetail.setId(UniqueIdUtil.getSuid());
                }
                sysModuleDetail.setModuleId(sysModule.getId());
                this.sysModuleDetailManager.create((Model)sysModuleDetail);
            }
        }
    }

    @Override
    public SysModule getModuleByCode(String code) {
        return ((SysModuleDao)this.baseMapper).getModuleByCode(code);
    }

    @Override
    public Map<String, String> exportModules(List<String> idList) throws JAXBException {
        SysModuleImportXml importXml = new SysModuleImportXml();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String id : idList) {
            SysModule module = (SysModule)this.get((Serializable)((Object)id));
            if (!BeanUtils.isNotEmpty((Object)((Object)module))) continue;
            SysModuleXml moduleXml = new SysModuleXml();
            moduleXml.setSysModule(module);
            List<SysModuleDetail> details = this.sysModuleDetailManager.getModuleDetail(id, null);
            moduleXml.setModuleDetail(details);
            importXml.addModuleXml(moduleXml);
        }
        map.put("module.xml", JAXBUtil.marshall((Object)importXml, SysModuleImportXml.class));
        return map;
    }

    @Override
    public void importModules(String unZipFilePath) throws JAXBException, UnsupportedEncodingException {
        String moduleXmlStr = FileUtil.readFile((String)(unZipFilePath + File.separator + "module.xml"));
        if (StringUtil.isNotEmpty((String)moduleXmlStr)) {
            SysModuleImportXml importXml = (SysModuleImportXml)JAXBUtil.unmarshall((String)moduleXmlStr, SysModuleImportXml.class);
            List<SysModuleXml> moduleXmls = importXml.getModuleXmlList();
            for (SysModuleXml sysModuleXml : moduleXmls) {
                SysModule module = sysModuleXml.getSysModule();
                IUser user = ContextUtil.getCurrentUser();
                module.setCreateBy(user.getFullname());
                module.setCreateBy(user.getUserId());
                module.setUpdateBy(user.getUserId());
                SysModule oldModule = this.getModuleByCode(module.getCode());
                if (BeanUtils.isEmpty((Object)((Object)oldModule))) {
                    module.setUpdateTime(LocalDateTime.now());
                    this.create((Model)module);
                    ThreadMsgUtil.addMsg((String)("\u6a21\u5757 \u201c" + module.getName() + "\u201d[" + module.getCode() + "] \u6dfb\u52a0\u6210\u529f\uff01"));
                } else {
                    module.setId(module.getId());
                    this.update((Model)module);
                    ThreadMsgUtil.addMsg((String)("\u6a21\u5757 \u201c" + module.getName() + "\u201d[" + module.getCode() + "] \u5df2\u5b58\u5728\uff0c\u66f4\u65b0\u6210\u529f\uff01"));
                }
                List<SysModuleDetail> details = sysModuleXml.getModuleDetail();
                this.sysModuleDetailManager.removeByModuleId((Serializable)((Object)module.getId()));
                if (!BeanUtils.isNotEmpty(details)) continue;
                for (SysModuleDetail detail : details) {
                    if (BeanUtils.isNotEmpty((Object)this.sysModuleDetailManager.get((Serializable)((Object)detail.getId())))) {
                        detail.setId(UniqueIdUtil.getSuid());
                    }
                    this.sysModuleDetailManager.create((Model)detail);
                }
            }
        }
    }
}

