/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.persistence.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.FileStorage;
import com.artfess.file.persistence.dao.FileConfigDao;
import com.artfess.file.persistence.dao.FileStorageDao;
import com.artfess.file.persistence.manager.FileStorageManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="fileStorageManager")
public class FileStorageManagerImpl
extends BaseManagerImpl<FileStorageDao, FileStorage>
implements FileStorageManager {
    @Resource
    FileConfigDao fileConfigDao;

    @Override
    public String insertFileStorage(FileStorage fileStorage) {
        Assert.notNull((Object)((Object)fileStorage), (String)"\u9644\u4ef6\u5b58\u50a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        boolean flag = this.checkSameField("", "CODE_", fileStorage.getCode());
        if (!flag) {
            throw new ApplicationException("\u7f16\u7801\u91cd\u590d\u8bf7\u4fee\u6539\uff01");
        }
        ((FileStorageDao)this.baseMapper).insert((Object)fileStorage);
        return fileStorage.getId();
    }

    @Override
    public String updateFileStorage(FileStorage fileStorage) {
        Assert.notNull((Object)((Object)fileStorage), (String)"\u9644\u4ef6\u5b58\u50a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        boolean flag = this.checkSameField(fileStorage.getId(), "CODE_", fileStorage.getCode());
        if (!flag) {
            throw new ApplicationException("\u7f16\u7801\u91cd\u590d\u8bf7\u4fee\u6539\uff01");
        }
        this.update((Model)fileStorage);
        return fileStorage.getId();
    }

    @Override
    @Transactional
    public String deleteFileStorage(String ... ids) {
        Assert.notEmpty((Object[])ids, (String)"\u53c2\u6570ids\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<String> idsList = Arrays.asList(ids);
        ArrayList<String> delIds = new ArrayList<String>();
        ArrayList<String> notDelIds = new ArrayList<String>();
        for (String storageId : idsList) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"STORAGE_ID_", (Object)storageId);
            int num = this.fileConfigDao.selectCount((Wrapper)queryWrapper);
            if (num == 0) {
                delIds.add(storageId);
                continue;
            }
            notDelIds.add(storageId);
        }
        if (BeanUtils.isNotEmpty(delIds)) {
            ((FileStorageDao)this.baseMapper).deleteBatchIds(delIds);
        }
        if (BeanUtils.isNotEmpty(notDelIds)) {
            return "\u4e3b\u952e\u4e3a\uff1a" + ((Object)notDelIds).toString() + "\u7684\u914d\u7f6e\u5df2\u88ab\u5e94\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01";
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public FileStorage getByCode(String code) {
        Assert.hasText((String)code, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"CODE_", (Object)code);
        return (FileStorage)((Object)((FileStorageDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }
}

