/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.util;

import cn.hutool.core.util.ReUtil;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.policy.PictureRenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.VerticalAlign;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.XmlCursor;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.springframework.util.ObjectUtils;

public class HtmlUtil {
    private static List<String> HTML_TAG = Arrays.asList("div", "a", "p", "img", "table", "ul", "font", "lable", "strong", "b", "span", "h1", "h2", "h3", "h4", "title");
    private static List<String> PICTURE_TAG = Arrays.asList("emf", "wmf", "pict", "jpeg", "png", "dib", "gif", "tiff", "eps", "bmp", "wpg");

    public static InputStream getResourceInputStream(String filePath) {
        InputStream in = FileUtil.class.getResourceAsStream(filePath);
        if (in != null) {
            return in;
        }
        return null;
    }

    public static AbstractRenderPolicy createHtmlRenderPolicy() {
        return new AbstractRenderPolicy(){

            protected void afterRender(RenderContext context) {
                1.clearPlaceholder((RenderContext)context, (boolean)true);
            }

            public void doRender(RenderContext context) throws Exception {
                XWPFRun run = context.getRun();
                Object data = context.getData();
                XWPFTemplate template = context.getTemplate();
                if (data == null || StringUtils.isBlank((CharSequence)data.toString())) {
                    return;
                }
                NiceXWPFDocument doc = template.getXWPFDocument();
                String html = data.toString();
                html = html.replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&nbsp;", " ").replaceAll("\\n", "").replaceAll("<br>", "\n");
                Document htmlDoc = Jsoup.parse((String)html);
                Elements nodes = htmlDoc.body().children();
                XWPFParagraph xwpfParagraph = doc.insertNewParagraph(run.getParagraph().getCTP().newCursor());
                if (BeanUtils.isEmpty((Object)xwpfParagraph)) {
                    xwpfParagraph = doc.insertNewParagraph((XmlCursor)run);
                }
                ListIterator itr = nodes.listIterator();
                while (itr.hasNext()) {
                    Element e = (Element)itr.next();
                    xwpfParagraph = HtmlUtil.parseHtmlToWord(e, doc, xwpfParagraph, true);
                }
            }
        };
    }

    private static XWPFParagraph parseHtmlToWord(Element ele, NiceXWPFDocument doc, XWPFParagraph xwpfParagraph, boolean isParent) throws Exception {
        XWPFRun run;
        boolean enabledBreak;
        if ("img".equals(ele.tagName())) {
            HtmlUtil.parseImgToWord(ele.attr("src"), xwpfParagraph);
            return xwpfParagraph;
        }
        if ("table".equals(ele.tagName())) {
            xwpfParagraph = doc.insertNewParagraph(HtmlUtil.getPrevXWPFParagraph(doc, xwpfParagraph).getCTP().newCursor());
            HtmlUtil.parseTableToWord(doc, ele, xwpfParagraph.createRun());
            return xwpfParagraph;
        }
        if ("sup".equalsIgnoreCase(ele.tagName())) {
            XWPFRun run2 = xwpfParagraph.createRun();
            run2.setText(ele.text());
            run2.setBold(true);
            run2.setFontSize(12);
            run2.setFontFamily("Times New Roman", XWPFRun.FontCharRange.ascii);
            run2.setFontFamily("\u5b8b\u4f53", XWPFRun.FontCharRange.eastAsia);
            run2.setSubscript(VerticalAlign.SUPERSCRIPT);
            TextRenderPolicy.Helper.renderTextRun((XWPFRun)run2, (Object)new TextRenderData(ele.text()));
            return xwpfParagraph;
        }
        String text = ele.ownText();
        boolean continueItr = true;
        if ("span".equalsIgnoreCase(ele.tagName())) {
            text = ele.ownText();
            continueItr = false;
        }
        if (enabledBreak = ReUtil.isMatch((String)"(p|h[12345]|li|img)", (CharSequence)ele.tagName())) {
            run = xwpfParagraph.createRun();
            run.addBreak();
        }
        if (StringUtils.isNotBlank((CharSequence)text)) {
            run = xwpfParagraph.createRun();
            TextRenderPolicy.Helper.renderTextRun((XWPFRun)run, (Object)new TextRenderData(text));
        }
        if (continueItr && ele.children().size() > 0) {
            ListIterator itr = ele.children().listIterator();
            while (itr.hasNext()) {
                Element me = (Element)itr.next();
                xwpfParagraph = HtmlUtil.parseHtmlToWord(me, doc, xwpfParagraph, false);
            }
        }
        return xwpfParagraph;
    }

    private static XWPFParagraph getPrevXWPFParagraph(NiceXWPFDocument doc, XWPFParagraph xwpfParagraph) {
        List xwpfParagraphs = doc.getXWPFDocument().getParagraphs();
        for (int i = 0; i < xwpfParagraphs.size(); ++i) {
            if (!((XWPFParagraph)xwpfParagraphs.get(i)).equals(xwpfParagraph)) continue;
            return (XWPFParagraph)xwpfParagraphs.get(i + 1);
        }
        return xwpfParagraph;
    }

    private static void parseImgToWord(String imgUrl, XWPFParagraph xwpfParagraph) throws Exception {
        if (imgUrl.contains("file/v1/downloadFile?fileId=")) {
            String regEx = "(\\?|&+)(.+?)=([^&]*)";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(imgUrl);
            String fileId = "";
            while (m.find()) {
                String paramName = m.group(2);
                if (!"fileId".equals(paramName)) continue;
                fileId = m.group(3);
                break;
            }
            if (StringUtil.isNotEmpty((String)fileId)) {
                FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
                DefaultFile file = (DefaultFile)fileManager.get((Serializable)((Object)fileId));
                if (BeanUtils.isNotEmpty((Object)((Object)file))) {
                    String format = file.getExtensionName();
                    if (!PICTURE_TAG.contains(format)) {
                        format = "png";
                    }
                    format = "." + format;
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    fileManager.downloadFile(fileId, outStream);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(outStream.toByteArray());
                    BufferedImage image = ImageIO.read(inputStream);
                    int width = image.getWidth();
                    int height = image.getHeight();
                    if (width > 600) {
                        int rate = width / 600 + 1;
                        width = width / rate - 20;
                        height /= rate;
                    }
                    PictureRenderData pictureRenderData = new PictureRenderData(width, height, format, image);
                    XWPFRun run = xwpfParagraph.createRun();
                    PictureRenderPolicy.Helper.renderPicture((XWPFRun)run, (PictureRenderData)pictureRenderData);
                }
                return;
            }
        } else {
            return;
        }
    }

    private static String getImgRealPath(String imgUrl) {
        if (imgUrl.startsWith("data:;base64,")) {
            imgUrl = imgUrl.replace("data:;base64,", "");
            byte[] bytes = Base64.getDecoder().decode(imgUrl);
            String path = "D:\\temp\\" + UUID.randomUUID().toString() + ".png";
            HtmlUtil.copyByte2File(bytes, new File(path));
            return path;
        }
        return "D:\\img\\timg.jpg";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyByte2File(byte[] bytes, File file) {
        FileOutputStream out = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            byte[] buffer = new byte[1024];
            out = new FileOutputStream(file);
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static void parseTableToWord(NiceXWPFDocument doc, Element ele, XWPFRun run) throws Exception {
        Document tableDoc = Jsoup.parse((String)HtmlUtil.simplifyTable(ele.outerHtml()));
        Elements trList = tableDoc.getElementsByTag("tr");
        Elements tdList = trList.get(0).getElementsByTag("td");
    }

    private static String simplifyTable(String tableContent) {
        if (StringUtils.isEmpty((CharSequence)tableContent)) {
            return null;
        }
        Document tableDoc = Jsoup.parse((String)tableContent);
        Elements trElements = tableDoc.getElementsByTag("tr");
        if (trElements != null) {
            Iterator eleIterator = trElements.iterator();
            Integer rowNum = 0;
            while (eleIterator.hasNext()) {
                Integer n = rowNum;
                Integer n2 = rowNum = Integer.valueOf(rowNum + 1);
                Element trElement = (Element)eleIterator.next();
                trElement.removeAttr("class");
                Elements tdElements = trElement.getElementsByTag("td");
                List<Element> tdEleList = HtmlUtil.covertElements2List(tdElements);
                for (int i = 0; i < tdEleList.size(); ++i) {
                    Element curTdElement = tdEleList.get(i);
                    curTdElement.removeAttr("class");
                    Element ele = curTdElement.clone();
                    String colspanValStr = curTdElement.attr("colspan");
                    if (StringUtils.isEmpty((CharSequence)colspanValStr)) continue;
                    ele.removeAttr("colspan");
                    Integer colspanVal = Integer.parseInt(colspanValStr);
                    for (int k = 0; k < colspanVal - 1; ++k) {
                        curTdElement.after(ele.outerHtml());
                    }
                }
            }
            List<Element> trEleList = HtmlUtil.covertElements2List(trElements);
            Element firstTrEle = trElements.first();
            Elements tdElements = firstTrEle.getElementsByTag("td");
            Integer tdCount = tdElements.size();
            for (int i = 0; i < tdElements.size(); ++i) {
                for (Element trElement : trEleList) {
                    List<Element> tdElementList = HtmlUtil.covertElements2List(trElement.getElementsByTag("td"));
                    try {
                        tdElementList.get(i);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    Node curTdNode = (Node)tdElementList.get(i);
                    Node cNode = curTdNode.clone();
                    String rowspanValStr = curTdNode.attr("rowspan");
                    if (StringUtils.isEmpty((CharSequence)rowspanValStr)) continue;
                    cNode.removeAttr("rowspan");
                    Element nextTrElement = trElement.nextElementSibling();
                    Integer rowspanVal = Integer.parseInt(rowspanValStr);
                    for (int j = 0; j < rowspanVal - 1; ++j) {
                        Node tempNode = cNode.clone();
                        ArrayList<Node> nodeList = new ArrayList<Node>();
                        nodeList.add(tempNode);
                        if (j > 0) {
                            nextTrElement = nextTrElement.nextElementSibling();
                        }
                        Integer indexNum = i + 1;
                        if (i == 0) {
                            indexNum = 0;
                        }
                        if (indexNum.equals(tdCount)) {
                            nextTrElement.appendChild(tempNode);
                            continue;
                        }
                        nextTrElement.insertChildren(indexNum.intValue(), nodeList);
                    }
                }
            }
        }
        Element tableEle = tableDoc.getElementsByTag("table").first();
        String tableHtml = tableEle.outerHtml();
        return tableHtml;
    }

    private static List<Element> covertElements2List(Elements curElements) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        for (Element curlement : curElements) {
            elementList.add(curlement);
        }
        return elementList;
    }

    public static boolean isHtml(String text) {
        if (StringUtil.isEmpty((String)text)) {
            return false;
        }
        Document document = Jsoup.parseBodyFragment((String)text, (String)"UTF-8");
        try {
            if (ObjectUtils.isEmpty((Object)document)) {
                return false;
            }
            Elements elements = document.getAllElements();
            for (Element e : elements) {
                String attrName = e.tag().getName();
                if (!HTML_TAG.contains(attrName.toLowerCase())) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getRichtextToDocx(String content) {
        PrintStream printStream = null;
        String basePath = (FileUtil.getIoTmpdir() + "/attachFiles/tempZip/printTrans/").replace("/", File.separator);
        String fileName = TimeUtil.getCurrentTimeMillis() + String.valueOf(new Random().nextInt(900) + 100);
        try {
            StringBuffer html = new StringBuffer();
            html.append("<html>").append("<head>").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />").append("</head>").append("<body>");
            html.append(content);
            html.append("</body></html>");
            File folder = new File(basePath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            printStream = new PrintStream((OutputStream)new FileOutputStream(basePath + fileName + ".html"), false, "utf-8");
            printStream.println(html.toString());
            WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
            NumberingDefinitionsPart ndp = new NumberingDefinitionsPart();
            wordMLPackage.getMainDocumentPart().addTargetPart((Part)ndp);
            ndp.unmarshalDefaultNumbering();
            XHTMLImporterImpl xHTMLImporter = new XHTMLImporterImpl(wordMLPackage);
            xHTMLImporter.setHyperlinkStyle("Hyperlink");
            wordMLPackage.getMainDocumentPart().getContent().addAll(xHTMLImporter.convert(new File(basePath + fileName + ".html"), null));
            File output = new File(basePath + fileName + ".docx");
            wordMLPackage.save(output);
            File file = output;
            return file;
        }
        catch (Exception e) {
            File file = null;
            return file;
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
            FileUtil.deleteFile((String)(basePath + fileName + ".html"));
        }
    }

    public static void printPicture(String key, String val, Map boMap, Map<String, Object> twiceMap) {
        try {
            JsonNode varNode = JsonUtil.toJsonNode((String)val.toString());
            if (varNode.isArray() && varNode.size() > 0) {
                FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
                ArrayNode arrayNode = (ArrayNode)varNode;
                if (BeanUtils.isNotEmpty((Object)arrayNode.get(0).get("signature"))) {
                    StringBuilder signatureTemp = new StringBuilder();
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        JsonNode inode = arrayNode.get(i);
                        String itemKey = key + "_" + i;
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        fileManager.downloadFile(inode.get("signature").asText(), outStream);
                        BufferedImage sourceImg = ImageIO.read(new ByteArrayInputStream(outStream.toByteArray()));
                        twiceMap.put(itemKey, new PictureRenderData(90, 25, ".png", sourceImg));
                        signatureTemp.append("{{@");
                        signatureTemp.append(itemKey);
                        signatureTemp.append("}}");
                    }
                    boMap.put(key, signatureTemp.toString());
                } else if (BeanUtils.isNotEmpty((Object)arrayNode.get(0).get("url")) || BeanUtils.isNotEmpty((Object)arrayNode.get(0).get("fileName"))) {
                    StringBuilder pictureTemp = new StringBuilder();
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        String url;
                        JsonNode inode = arrayNode.get(i);
                        if (!BeanUtils.isNotEmpty((Object)inode.get("url")) || (url = inode.get("url").asText()).indexOf("getFileById_") == -1) continue;
                        String[] urlItem = url.split("getFileById_");
                        String itemKey = key + "_" + i;
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        fileManager.downloadFile(urlItem[1], outStream);
                        BufferedImage sourceImg = ImageIO.read(new ByteArrayInputStream(outStream.toByteArray()));
                        int width = sourceImg.getWidth();
                        int height = sourceImg.getHeight();
                        if (width > 520) {
                            double mul = new BigDecimal((float)width / 520.0f).setScale(2, 4).doubleValue();
                            width = (int)((double)width / mul);
                            height = (int)((double)height / mul);
                        }
                        twiceMap.put(itemKey, new PictureRenderData(width, height, ".png", sourceImg));
                        pictureTemp.append("\n{{@");
                        pictureTemp.append(itemKey);
                        pictureTemp.append("}}");
                    }
                    boMap.put(key, pictureTemp.toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

