/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.api.constant.VoteResult;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.persistence.dao.BpmSignDataDao;
import com.artfess.bpm.persistence.manager.ActExecutionManager;
import com.artfess.bpm.persistence.manager.BpmSignDataManager;
import com.artfess.bpm.persistence.model.ActExecution;
import com.artfess.bpm.persistence.model.BpmSignData;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmSignDataManager")
public class BpmSignDataManagerImpl
extends BaseManagerImpl<BpmSignDataDao, BpmSignData>
implements BpmSignDataManager {
    @Resource
    ActExecutionManager actExecutionManager;

    @Override
    public List<BpmSignData> getVoteByExecuteNode(String executeId, String nodeId, Integer isActive) {
        return ((BpmSignDataDao)this.baseMapper).getVoteByExecuteNode(executeId, nodeId, isActive);
    }

    @Override
    public BpmSignData getSignData(BpmTask bpmTask, String executeId, BpmIdentity bpmIdentity) {
        BpmSignData signData = new BpmSignData();
        signData.setId(UniqueIdUtil.getSuid());
        signData.setDefId(bpmTask.getProcDefId());
        signData.setInstId(bpmTask.getProcInstId());
        signData.setExecuteId(executeId);
        signData.setActInstId(bpmTask.getBpmnInstId());
        signData.setNodeId(bpmTask.getNodeId());
        signData.setTaskId(bpmTask.getTaskId());
        signData.setQualifiedId(bpmIdentity.getId());
        signData.setQualifiedName(bpmIdentity.getName());
        signData.setCreateTime(LocalDateTime.now());
        signData.setVoteResult(VoteResult.NO.getKey());
        signData.setIsActive(1);
        return signData;
    }

    @Override
    @Transactional
    public void addSignData(String defId, String instId, String actInstId, String executeId, String nodeId, String taskId, String qualifiedId, String qualifiedName, Short index, String signType) {
        BpmSignData signData = new BpmSignData();
        signData.setId(UniqueIdUtil.getSuid());
        signData.setDefId(defId);
        signData.setInstId(instId);
        signData.setExecuteId(executeId);
        signData.setActInstId(actInstId);
        signData.setNodeId(nodeId);
        signData.setTaskId(taskId);
        signData.setQualifiedId(qualifiedId);
        signData.setQualifiedName(qualifiedName);
        signData.setCreateTime(LocalDateTime.now());
        signData.setVoteResult(VoteResult.NO.getKey());
        signData.setIndex(index);
        signData.setIsActive(1);
        signData.setType(signType);
        super.create((Model)signData);
    }

    @Override
    @Transactional
    public void delByInstList(List<String> instList) {
        ((BpmSignDataDao)this.baseMapper).delByInstList(instList);
    }

    @Override
    @Transactional
    public void vote(String executeId, String nodeId, Short index, String actionName) {
        ActExecution execution;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("executeId", executeId);
        params.put("nodeId", nodeId);
        params.put("index", index);
        BpmSignData signData = ((BpmSignDataDao)this.baseMapper).getByExeNodeIndex(executeId, nodeId, index);
        if (BeanUtils.isEmpty((Object)((Object)signData)) && BeanUtils.isNotEmpty((Object)(execution = (ActExecution)this.actExecutionManager.get((Serializable)((Object)executeId))))) {
            signData = ((BpmSignDataDao)this.baseMapper).getByExeNodeIndex(execution.getParentId(), nodeId, index);
        }
        IUser user = ContextUtil.getCurrentUser();
        String userId = "-1";
        String userName = "\u7cfb\u7edf";
        if (user != null) {
            userId = user.getUserId();
            userName = user.getFullname();
        }
        signData.setVoteResult(actionName);
        signData.setVoteId(userId);
        signData.setVoter(userName);
        signData.setVoteTime(LocalDateTime.now());
        super.update((Model)signData);
    }

    @Override
    @Transactional
    public void updByNotActive(String actExecuteId, String nodeId) {
        ((BpmSignDataDao)this.baseMapper).updByNotActive(actExecuteId, nodeId);
    }

    @Override
    @Transactional
    public void removeByNotActive(String actExecuteId, String nodeId) {
        ((BpmSignDataDao)this.baseMapper).removeByNotActive(actExecuteId, nodeId);
    }

    @Override
    public BpmSignData getByInstanIdAndUserId(String instancId, String userId, String taskId) {
        return ((BpmSignDataDao)this.baseMapper).getByInstanIdAndUserId(instancId, userId, taskId);
    }

    @Override
    @Transactional
    public List<BpmIdentity> getByInstanIdAndNodeIdAndNo(String instId, String nodeId) {
        List<BpmSignData> bpmSignDatas = ((BpmSignDataDao)this.baseMapper).getByInstanIdAndNodeIdAndNo(instId, nodeId);
        ArrayList<BpmIdentity> result = new ArrayList<BpmIdentity>();
        for (BpmSignData bpmSignData : bpmSignDatas) {
            DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
            bpmIdentity.setType("user");
            bpmIdentity.setId(bpmSignData.getQualifiedId());
            bpmIdentity.setName(bpmSignData.getQualifiedName());
            result.add(bpmIdentity);
        }
        ((BpmSignDataDao)this.baseMapper).deleteByInstanIdAndNodeIdAndNo(instId, nodeId);
        ((BpmSignDataDao)this.baseMapper).updByActive(instId, nodeId);
        return result;
    }
}

