/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.dao.PropertiesDao;
import com.artfess.uc.exception.RequiredException;
import com.artfess.uc.manager.PropertiesService;
import com.artfess.uc.model.Properties;
import com.artfess.uc.params.properties.PropertiesVo;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PropertiesManagerImpl
extends BaseManagerImpl<PropertiesDao, Properties>
implements PropertiesService {
    @Override
    public List<String> getGroups() {
        return ((PropertiesDao)this.baseMapper).getGroups();
    }

    @Override
    public boolean isExist(Properties properties) {
        Integer rtn = ((PropertiesDao)this.baseMapper).isExist(properties.getCode(), properties.getId());
        return rtn > 0;
    }

    @Override
    public Map<String, String> reloadProperty() {
        HashMap<String, String> map = new HashMap<String, String>();
        List list = this.getAll();
        for (Properties property : list) {
            map.put(property.getCode().toLowerCase(), property.getRealVal());
        }
        return map;
    }

    @Override
    public String getByCode(String code) {
        Properties properties = ((PropertiesDao)this.baseMapper).getByCode(code);
        return properties.getValue();
    }

    @Override
    public String getByCode(String code, String defaultValue) {
        String val = this.getByCode(code);
        if (StringUtil.isEmpty((String)val)) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public Integer getIntByCode(String code) {
        String val = this.getByCode(code);
        if (StringUtil.isEmpty((String)val)) {
            return 0;
        }
        Integer rtn = Integer.parseInt(val);
        return rtn;
    }

    @Override
    public Integer getIntByCode(String code, Integer defaulValue) {
        String val = this.getByCode(code);
        if (StringUtil.isEmpty((String)val)) {
            return defaulValue;
        }
        Integer rtn = Integer.parseInt(val);
        return rtn;
    }

    @Override
    public Long getLongByCode(String code) {
        String val = this.getByCode(code);
        if (StringUtil.isEmpty((String)val)) {
            return 0L;
        }
        Long rtn = Long.parseLong(val);
        return rtn;
    }

    @Override
    public boolean getBooleanByCode(String code) {
        String val = this.getByCode(code);
        return Boolean.parseBoolean(val);
    }

    @Override
    public boolean getBooleanByCode(String code, boolean defaulValue) {
        String val = this.getByCode(code);
        if (StringUtil.isEmpty((String)val)) {
            return defaulValue;
        }
        if ("1".equals(val)) {
            return true;
        }
        return Boolean.parseBoolean(val);
    }

    @Override
    public Properties getPropertiesByCode(String code) {
        return ((PropertiesDao)this.baseMapper).getByCode(code);
    }

    @Override
    @Transactional
    public void removeByCode(String ... codes) {
        for (String als : codes) {
            ((PropertiesDao)this.baseMapper).removeByCode(als, LocalDateTime.now());
        }
    }

    @Override
    @Transactional
    public CommonResult<String> updateProperties(PropertiesVo propertiesVo) throws Exception {
        if (StringUtil.isEmpty((String)propertiesVo.getCode())) {
            throw new RequiredException("\u66f4\u65b0\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\uff0c\u7cfb\u7edf\u53c2\u6570\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        Properties properties = ((PropertiesDao)this.baseMapper).getByCode(propertiesVo.getCode());
        if (BeanUtils.isEmpty((Object)properties)) {
            return new CommonResult(false, "\u66f4\u65b0\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\uff0c\u7cfb\u7edf\u53c2\u6570\u7f16\u7801\u3010" + properties.getCode() + "\u3011\u4e0d\u5b58\u5728\uff01", (Object)"");
        }
        if (StringUtil.isNotEmpty((String)propertiesVo.getName())) {
            properties.setName(propertiesVo.getName());
        }
        if (propertiesVo.getGroup() != null) {
            properties.setGroup(propertiesVo.getGroup());
        }
        if (propertiesVo.getValue() != null) {
            properties.setValue(propertiesVo.getValue());
        }
        if (propertiesVo.getDescription() != null) {
            properties.setDescription(propertiesVo.getDescription());
        }
        this.update((Model)properties);
        return new CommonResult(true, "\u66f4\u65b0\u7cfb\u7edf\u53c2\u6570\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((PropertiesDao)this.baseMapper).removePhysical();
    }
}

