/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.form.model.CustomDialog;
import com.artfess.form.persistence.manager.CombinateDialogManager;
import com.artfess.form.persistence.manager.CustomDialogManager;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/form/customDialog/v1"})
@Api(tags={"\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846"})
@ApiGroup(group={"group_form"})
public class CustomDialogController
extends BaseController<CustomDialogManager, CustomDialog> {
    @Resource
    CombinateDialogManager combinateDialogManager;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    CustomDialogManager customDialogManager;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return ((CustomDialogManager)this.baseService).query(queryFilter);
    }

    @RequestMapping(value={"getAll"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846", httpMethod="POST", notes="\u67e5\u8be2\u6240\u6709\u7684\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846")
    public List<CustomDialog> getAll() throws Exception {
        List customDialogs = ((CustomDialogManager)this.baseService).list();
        return customDialogs;
    }

    @RequestMapping(value={"getAllDialogs"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fd4\u56de\u7ec4\u5408\u5bf9\u8bdd\u6846\u548c\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846", httpMethod="POST", notes="\u8fd4\u56de\u7ec4\u5408\u5bf9\u8bdd\u6846\u548c\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846")
    public List<Object> getAllDialogs() throws Exception {
        List customDialogs = ((CustomDialogManager)this.baseService).list();
        customDialogs.addAll(this.combinateDialogManager.list());
        return customDialogs;
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u522b\u540d\u83b7\u53d6\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846", httpMethod="GET", notes="\u6839\u636e\u522b\u540d\u83b7\u53d6\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846")
    public CustomDialog getByAlias(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam String alias) throws Exception {
        CustomDialog customDialog = null;
        if (StringUtil.isNotEmpty((String)alias)) {
            customDialog = ((CustomDialogManager)this.baseService).getByAlias(alias);
        }
        if (customDialog == null) {
            customDialog = new CustomDialog();
        }
        return customDialog;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u4fe1\u606f")
    public CommonResult save(@ApiParam(name="json", value="\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846JSON\u5bf9\u8c61") @RequestBody String json) throws Exception {
        String resultMsg;
        CustomDialog customDialog = null;
        if (!StringUtil.isEmpty((String)json)) {
            ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)json);
            String displayfield = node.get("displayfield") + "";
            String conditionfield = node.get("conditionfield") + "";
            String resultfield = node.get("resultfield") + "";
            String sortfield = node.get("sortfield") + "";
            String combinationRule = "";
            if (BeanUtils.isNotEmpty((Object)node.get("combinationRule"))) {
                combinationRule = node.get("combinationRule") + "";
            }
            node.remove("displayfield");
            node.remove("conditionfield");
            node.remove("resultfield");
            node.remove("sortfield");
            node.remove("combinationRule");
            customDialog = (CustomDialog)((Object)JsonUtil.toBean((JsonNode)node, CustomDialog.class));
            customDialog.setDisplayfield(displayfield);
            customDialog.setConditionfield(conditionfield);
            customDialog.setResultfield(resultfield);
            customDialog.setSortfield(sortfield);
            if (BeanUtils.isNotEmpty((Object)combinationRule)) {
                customDialog.setCombinationRule(combinationRule);
            }
            if (2 == customDialog.getStyle()) {
                String listDialogAlias = JsonUtil.toJsonNode((String)combinationRule).get("rightDialog").asText();
                CustomDialog listDialog = ((CustomDialogManager)this.baseService).getByAlias(listDialogAlias);
                if (BeanUtils.isEmpty((Object)((Object)listDialog))) {
                    throw new BaseException("\u5217\u8868\u5bf9\u8bdd\u6846\u3010" + listDialogAlias + "\u3011\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8be5\u5bf9\u8bdd\u6846\u662f\u5426\u5b58\u5728");
                }
                customDialog.setObjName(listDialog.getObjName());
                customDialog.setNeedPage(listDialog.getNeedPage());
                customDialog.setPageSize(listDialog.getPageSize());
                customDialog.setDisplayfield(listDialog.getDisplayfield());
                customDialog.setConditionfield(listDialog.getConditionfield());
                customDialog.setResultfield(listDialog.getResultfield());
                customDialog.setSortfield(listDialog.getSortfield());
                customDialog.setDsalias(listDialog.getDsalias());
                customDialog.setIsTable(listDialog.getIsTable());
                customDialog.setDiySql(listDialog.getDiySql());
                customDialog.setSqlBuildType(listDialog.getSqlBuildType());
                customDialog.setSelectNum(listDialog.getSelectNum());
                customDialog.setSystem(listDialog.getSystem());
                customDialog.setDsType(listDialog.getDsType());
                customDialog.setUrl(listDialog.getUrl());
                customDialog.setRequestType(listDialog.getRequestType());
                customDialog.setDataParam(listDialog.getDataParam());
                customDialog.setPageKey(listDialog.getPageKey());
                customDialog.setPageSizeKey(listDialog.getPageSizeKey());
                customDialog.setTotalKey(listDialog.getTotalKey());
                customDialog.setListKey(listDialog.getListKey());
                customDialog.setHeader(listDialog.getHeader());
                customDialog.setCombinationRule(combinationRule);
            }
        }
        if (StringUtil.isEmpty((String)customDialog.getId())) {
            if (((CustomDialogManager)this.baseService).getByAlias(customDialog.getAlias()) != null) {
                return new CommonResult(false, "\u522b\u540d" + customDialog.getAlias() + "\uff0c\u5df2\u5b58\u5728", null);
            }
            customDialog.setId(UniqueIdUtil.getSuid());
            customDialog.setUpdateTime(DateUtil.getCurrentDate());
            ((CustomDialogManager)this.baseService).create((Model)customDialog);
            resultMsg = "\u6dfb\u52a0\u6210\u529f";
        } else {
            ((CustomDialogManager)this.baseService).update((Model)customDialog);
            resultMsg = "\u66f4\u65b0\u6210\u529f";
        }
        return new CommonResult(true, resultMsg, null);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u8bb0\u5f55")
    public CommonResult remove(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        String msg = "\u5220\u9664\u6210\u529f";
        boolean index = true;
        CustomDialog customDialog = (CustomDialog)((CustomDialogManager)this.baseService).get((Serializable)((Object)id));
        if (customDialog.getSystem() == null || !customDialog.getSystem().booleanValue()) {
            ((CustomDialogManager)this.baseService).remove((Serializable)((Object)id));
        } else {
            index = false;
            msg = "id:" + id + "\u662f\u7cfb\u7edf\u9ed8\u8ba4\u4e0d\u80fd\u5220\u9664";
        }
        return new CommonResult(index, msg);
    }

    @RequestMapping(value={"removes"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49")
    public CommonResult<String> batchRemove(String ... ids) throws Exception {
        ((CustomDialogManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"getTreeData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u6811\u5f62\u6570\u636e\u3002", httpMethod="GET", notes="\u53d6\u5f97\u6811\u5f62\u6570\u636e\u3002")
    public List getTreeData(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam String alias, @ApiParam(name="mapParam", value="\u52a8\u6001\u4f20\u5165\u7684\u5b57\u6bb5") @RequestParam String mapParam) throws Exception {
        CustomDialog customDialog = null;
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)mapParam)) {
            mapParam = "{" + mapParam + "}";
            Map map = JsonUtil.toMap((String)mapParam);
            for (Object key : map.keySet()) {
                param.put(key + "", map.get(key));
            }
        }
        if (StringUtil.isNotEmpty((String)alias)) {
            // empty if block
        }
        if ((customDialog = ((CustomDialogManager)this.baseService).getByAlias(alias)) == null) {
            return null;
        }
        try {
            DatabaseSwitchResult dResult = this.databaseContext.setDataSource(customDialog.getDsalias());
            Object object = null;
            try {
                List list = ((CustomDialogManager)this.baseService).geTreetData(customDialog, param, dResult.getDbType());
                return list;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dResult != null) {
                    if (object != null) {
                        try {
                            dResult.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dResult.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"getListData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u67e5\u8be2", httpMethod="POST", notes="\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u67e5\u8be2")
    public Object getListData(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam String alias, @ApiParam(name="filter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter filter, @ApiParam(name="mapParam", value="") @RequestParam String mapParam) throws Exception {
        return ((CustomDialogManager)this.baseService).getCustomDialogData(alias, filter, mapParam);
    }

    @RequestMapping(value={"mobileCustomDialog"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u624b\u673a\u7aef\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846", httpMethod="POST", notes="\u624b\u673a\u7aef\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846")
    public CommonResult mobileDialog(@ApiParam(name="isCombine", value="") @RequestBody Boolean isCombine, @ApiParam(name="alias", value="\u522b\u540d") @RequestBody String alias) throws Exception {
        Map mv = ((CustomDialogManager)this.baseService).getMobileCustomDialogData(isCombine, alias);
        return new CommonResult(true, null, (Object)mv);
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        String[] idList = ids.split(",");
        String fileName = "customDialog_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        String json = this.customDialogManager.export(idList);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"customDialog.json", (String)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846", httpMethod="POST", notes="\u5bfc\u5165\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846")
    public CommonResult<String> importCustom(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            this.customDialogManager.importFile(unZipFilePath);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }
}

