/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataResource.app.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.dataResource.app.dao.BizAppCatalogsTableDao;
import com.artfess.dataShare.dataResource.app.manager.BizAppCatalogsTableFieldManager;
import com.artfess.dataShare.dataResource.app.manager.BizAppCatalogsTableManager;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTable;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTableField;
import com.artfess.dataShare.dataResource.app.vo.BizAppTableDetailVo;
import com.artfess.dataShare.dataResource.app.vo.BizAppTableVo;
import com.artfess.dataShare.factory.QueryDataTableFactory;
import com.artfess.dataShare.factory.QueryParam;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import com.artfess.dataShare.util.DorisUtils;
import com.artfess.dataShare.util.EasyExcelUtil;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.poi.util.ExcelTool;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizAppCatalogsTableManagerImpl
extends BaseManagerImpl<BizAppCatalogsTableDao, BizAppCatalogsTable>
implements BizAppCatalogsTableManager {
    @Resource
    BizAppCatalogsTableFieldManager appCatalogsTableFieldManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void export(MultipartFile file, String catalogId) throws Exception {
        ExcelTool util = new ExcelTool(BizAppTableVo.class);
        List list = util.importExcel(file.getInputStream(), Integer.valueOf(3), Integer.valueOf(4));
        if ((list = list.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getTableNameEn())).collect(Collectors.toList())).size() == 0) {
            throw new BaseException("\u8868\u6ca1\u6709\u68c0\u6d4b\u5230\u9700\u8981\u5bfc\u5165\u7684\u6570\u636e\uff0c\u6ce8\u610f\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        for (BizAppTableVo vo : list) {
            if (StringUtil.isEmpty((String)vo.getTableNameCh())) continue;
            if (StringUtil.isEmpty((String)vo.getTableNameCh())) {
                throw new BaseException("\u8868" + vo.getName() + "\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)vo.getTableNameEn())) {
                throw new BaseException("\u8868" + vo.getName() + "\u82f1\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!this.checkTable(vo.getCode())) continue;
            throw new BaseException("\u8868\u3010" + vo.getName() + "(" + vo.getCode() + ")\u3011\u5df2\u7ecf\u5b58\u5728");
        }
        for (BizAppTableVo vo : list) {
            if (StringUtil.isEmpty((String)vo.getCode())) continue;
            BizAppCatalogsTable table = BizAppTableVo.parseTable(vo);
            table.setAppCatalogsId(catalogId);
            table.setIsCreateTable("0");
            table.setDeployed("0");
            table.setIsDele("0");
            table.setTableNameEn("app_" + table.getTableNameEn());
            this.create((Model)table);
        }
    }

    public boolean checkTable(String tableName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TABLE_NAME_EN_", (Object)tableName);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    public void downloadMainTempFile(HttpServletResponse response, String tableId) throws Exception {
        BizAppCatalogsTable dwTable = (BizAppCatalogsTable)((Object)this.getById((Serializable)((Object)tableId)));
        List<BizAppCatalogsTableField> field = this.appCatalogsTableFieldManager.queryFieldByTableId(tableId);
        if (field.size() == 0) {
            throw new ApplicationException("\u8d44\u6e90\u8868\u672a\u8bbe\u7f6e\u5b57\u6bb5\u3002");
        }
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        for (BizAppCatalogsTableField field1 : field) {
            if (!"2".equals(field1.getFieldType())) continue;
            exportMap.put(field1.getName(), field1.getDesc());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)dwTable.getName(), (int)12, exportMap, new ArrayList(), (int)0);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)(dwTable.getName() + "_\u5bfc\u5165\u6a21\u677f"), (HttpServletResponse)response);
    }

    @Override
    @Transactional
    public void importMain(MultipartFile file, String tableId) throws Exception {
        BizAppCatalogsTable dwTable = (BizAppCatalogsTable)((Object)this.getById((Serializable)((Object)tableId)));
        if ("1".equals(dwTable.getTableClass())) {
            this.importWExcelData(file, dwTable);
        } else if ("2".equals(dwTable.getTableClass())) {
            this.exportDExcelData(file, dwTable);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void importWExcelData(MultipartFile file, BizAppCatalogsTable dwTable) throws Exception {
        List<BizAppCatalogsTableField> fieldLists = this.appCatalogsTableFieldManager.queryFieldByTableId(dwTable.getId());
        HashMap<String, String> nameFieldMap = new HashMap<String, String>();
        for (BizAppCatalogsTableField field : fieldLists) {
            nameFieldMap.put(field.getDesc(), field.getFieldCode());
        }
        List rows = ExcelUtil.ImportDate((MultipartFile)file);
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)"app");
        for (Map row : rows) {
            StringBuffer sql = new StringBuffer("insert into ");
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            fields.add(BizAppCatalogsTableField.PK_NAME);
            values.add("'" + UniqueIdUtil.getSuid() + "'");
            for (Map.Entry map : row.entrySet()) {
                if (!BeanUtils.isNotEmpty(map.getValue())) continue;
                String key = (String)map.getKey();
                String field = this.getFieldName(key, fieldLists, (String)nameFieldMap.get(key));
                fields.add(field);
                String dataType = this.getDataType(key, fieldLists, (String)nameFieldMap.get(key));
                if ("number".equals(dataType)) {
                    values.add("'" + (String)map.getValue() + "'");
                    continue;
                }
                values.add("'" + (String)map.getValue() + "'");
            }
            sql.append(dwTable.getTableNameEn());
            sql.append("(" + String.join((CharSequence)",", fields) + ")");
            sql.append(" values ");
            sql.append("(" + String.join((CharSequence)",", values) + ")");
            jdbcTemplate.execute(sql.toString());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void exportDExcelData(MultipartFile file, BizAppCatalogsTable dwTable) throws Exception {
        List<Object> data = EasyExcelUtil.readMoreThan1000Row(file.getInputStream());
        List<BizAppCatalogsTableField> fields = this.appCatalogsTableFieldManager.queryFieldByTableId(dwTable.getId());
        fields = fields.stream().filter(p -> p.getFieldType().equals("2")).collect(Collectors.toList());
        Map<String, BizAppCatalogsTableField> fieldMap = fields.stream().collect(Collectors.toMap(p -> p.getFieldCode(), p -> p));
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)"app");
        String tableName = dwTable.getTableNameEn().replace("app_", "");
        IUser user = ContextUtil.getCurrentUser();
        IGroup org = ContextUtil.getCurrentGroup();
        String uId = user.getUserId();
        String tenantId = user.getTenantId();
        String orgId = org.getGroupId();
        String insertDsql = "insert into APP_D_" + tableName + "(id_,user_id_,user_name_,USER_SEX_,USER_IDENTITY_CARD_," + "USER_PHONE_,DATA_ID_,DATA_JSON_,FIELD_VALUE_TIME_,VERSION,CREATE_BY_,CREATE_ORG_ID_,CREATE_TIME_,TENANT_ID_)" + " values(?,?,?,?,?,?,?,?,?,?,?,?,now(),?)";
        String recordTable = "APP_D_" + tableName + "_COLUMN";
        String insertSql = "insert into " + recordTable + "(id_,user_id_,user_name_,USER_SEX_,USER_IDENTITY_CARD_,USER_PHONE_,DATA_ID_," + "FIELD_ID_,FIELD_CODE_,FIELD_VALUE_,FIELD_UI_MODULE_,FIELD_VALUE_TIME_,VERSION,CREATE_BY_,CREATE_ORG_ID_,CREATE_TIME_,TENANT_ID_)" + " values (?,?,?,?,?,?,?, ?,?,?,?,?,?,?,?,now(),?)";
        ArrayList<Object[]> dDataList = new ArrayList<Object[]>();
        ArrayList<Object[]> rDataList = new ArrayList<Object[]>();
        ArrayList<String> fieldList = new ArrayList<String>();
        for (int i = 0; i < data.size(); ++i) {
            List rows = (List)data.get(i);
            if (i == 0) {
                String string = (String)rows.get(0);
                continue;
            }
            if (i == 1) {
                for (String field : rows) {
                    String fieldName = field.substring(field.indexOf("-") + 1);
                    fieldList.add(fieldName);
                }
                continue;
            }
            String pcId = UniqueIdUtil.getSuid();
            JSONObject jsonObject = new JSONObject();
            String userName = (String)rows.get(0);
            String userSex = (String)rows.get(1);
            String userIdentityCard = (String)rows.get(2);
            String userPhone = (String)rows.get(3);
            for (int j = 4; j < rows.size(); ++j) {
                String value = (String)rows.get(j);
                jsonObject.put(fieldMap.get(fieldList.get(j)).getFieldCode(), (Object)value);
            }
            ArrayList<Object> dParam = new ArrayList<Object>();
            dParam.add(UniqueIdUtil.getSuid());
            dParam.add("");
            dParam.add(userName);
            dParam.add(userSex);
            dParam.add(userIdentityCard);
            dParam.add(userPhone);
            dParam.add(pcId);
            dParam.add(jsonObject.toJSONString());
            dParam.add(LocalDateTime.now());
            dParam.add(1);
            dParam.add(uId);
            dParam.add(orgId);
            dParam.add(tenantId);
            dDataList.add(dParam.toArray());
            for (int j = 4; j < rows.size(); ++j) {
                String value = (String)rows.get(j);
                BizAppCatalogsTableField tableField = fieldMap.get(fieldList.get(j));
                ArrayList<Object> rParam = new ArrayList<Object>();
                rParam.add(UniqueIdUtil.getSuid());
                rParam.add("1");
                rParam.add(userName);
                rParam.add(userSex);
                rParam.add(userIdentityCard);
                rParam.add(userPhone);
                rParam.add(pcId);
                rParam.add(tableField.getId());
                rParam.add(tableField.getFieldCode());
                rParam.add(value);
                rParam.add(tableField.getUiComCode());
                rParam.add(LocalDateTime.now());
                rParam.add(1);
                rParam.add(uId);
                rParam.add(orgId);
                rParam.add(tenantId);
                rDataList.add(rParam.toArray());
            }
        }
        jdbcTemplate.batchUpdate(insertDsql, dDataList);
        jdbcTemplate.batchUpdate(insertSql, rDataList);
    }

    private String getFieldName(String key, List<BizAppCatalogsTableField> columnList, String fieldName) {
        for (BizAppCatalogsTableField boAtt : columnList) {
            if (!boAtt.getDesc().equals(key) && !boAtt.getName().equals(fieldName)) continue;
            return boAtt.getFieldCode();
        }
        return "";
    }

    private String getDataType(String key, List<BizAppCatalogsTableField> columnList, String fieldName) {
        for (BizAppCatalogsTableField boAtt : columnList) {
            if (!boAtt.getDesc().equals(key) && !boAtt.getName().equals(fieldName)) continue;
            return boAtt.getDataType();
        }
        return "";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void Deploy(String tableId) throws Exception {
        Assert.notNull((Object)tableId, (String)"\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
        BizAppCatalogsTable table = (BizAppCatalogsTable)((Object)this.getById((Serializable)((Object)tableId)));
        String tableName = table.getTableNameEn();
        String tableDesc = table.getTableDesc() == null ? table.getTableNameCh() : table.getTableDesc();
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"app");
        List<BizAppCatalogsTableField> fieldList = this.appCatalogsTableFieldManager.queryFieldByTableId(tableId);
        if (fieldList.size() == 0) {
            throw new ApplicationException("\u8868\u5185\u6ca1\u6709\u5b57\u6bb5\u4e0d\u80fd\u53d1\u5e03");
        }
        if ("1".equals(table.getDeployed())) {
            for (BizAppCatalogsTableField field : fieldList) {
                if ("1".equals(field.getIsCreate())) continue;
                field.setIsCreate("1");
                Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
                Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
                String fieldSq = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + field.getFieldCode() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT '" + field.getDesc() + "' ";
                field.setDecimalLen(decimalLen);
                field.setFlSql(fieldSq);
                template.execute(fieldSq);
            }
            this.appCatalogsTableFieldManager.updateBatchById(fieldList);
        } else {
            for (BizAppCatalogsTableField field : fieldList) {
                field.setIsCreate("1");
                Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
                Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
                String fieldSq = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + field.getFieldCode() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT '" + field.getDesc() + "' ";
                field.setDecimalLen(decimalLen);
                field.setFlSql(fieldSq);
            }
            this.appCatalogsTableFieldManager.updateBatchById(fieldList);
            table.setIsCreateTable("1");
            table.setCode(table.getTableNameEn());
            table.setDeployed("1");
            table.setDeployedTime(LocalDateTime.now());
            String createSql = DorisUtils.createAppTable(template, table.getTableNameEn(), tableDesc, fieldList);
            table.setCreateTableSql(createSql);
            this.update((Model)table);
        }
    }

    @Override
    public BizAppTableDetailVo queryTableVo(String tableId) throws Exception {
        Assert.notNull((Object)tableId, (String)"\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
        BizAppTableDetailVo vo = new BizAppTableDetailVo();
        BizAppCatalogsTable table = (BizAppCatalogsTable)((Object)this.getById((Serializable)((Object)tableId)));
        if (null == table) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u8868");
        }
        vo.setTable(table);
        vo.setFieldList(this.appCatalogsTableFieldManager.queryFieldByTableId(tableId));
        return vo;
    }

    @Override
    public QueryResultData queryTableData(QueryParamVo queryParamVo) throws Exception {
        if (StringUtil.isEmpty((String)queryParamVo.getTableId()) && StringUtil.isEmpty((String)queryParamVo.getTableName())) {
            throw new ApplicationException("\u8868ID\u6216\u8005\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryParam queryParam = new QueryParam();
        BeanUtils.copyNotNullProperties((Object)queryParam, (Object)queryParamVo);
        BizAppCatalogsTable table = null;
        if (StringUtil.isNotEmpty((String)queryParam.getTableId())) {
            table = (BizAppCatalogsTable)((Object)this.getById((Serializable)((Object)queryParam.getTableId())));
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TABLE_NAME_EN_", (Object)queryParamVo.getTableName());
            table = (BizAppCatalogsTable)((Object)((BizAppCatalogsTableDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        }
        if (table == null) {
            return null;
        }
        queryParam.setTableName(table.getTableNameEn());
        List<BizAppCatalogsTableField> fieldList = this.appCatalogsTableFieldManager.queryFieldByTableId(table.getId());
        Map<String, String> field = fieldList.stream().filter(p -> "2".equals(p.getFieldType())).collect(Collectors.toMap(BizAppCatalogsTableField::getFieldCode, p -> p.getName()));
        field.put("id_", "\u4e3b\u952e");
        queryParam.setField(field);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"app");
        queryParam.setJdbcTemplate(template);
        queryParam.setDbType("mysql");
        return QueryDataTableFactory.getTableData(queryParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTable(String tableId) throws Exception {
        BizAppCatalogsTable table = (BizAppCatalogsTable)((Object)this.getById((Serializable)((Object)tableId)));
        boolean exists = this.checkPhysicsTableExists(table.getTableNameEn());
        if (exists && "1".equals(table.getDeployed())) {
            String dropSql = "drop table " + table.getTableNameEn();
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"app");
            template.execute(dropSql);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"table_id_", (Object)tableId);
        this.removeById((Serializable)((Object)tableId));
        this.appCatalogsTableFieldManager.remove((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deployHaveTable(String tableId) throws Exception {
        BizAppCatalogsTable table = (BizAppCatalogsTable)this.get((Serializable)((Object)tableId));
        if ("1".equals(table.getDeployed())) {
            throw new ApplicationException("\u8868\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u4ece\u91cd\u590d\uff0c\u5982\u679c\u6709\u95ee\u9898\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        table.setIsCreateTable("1");
        table.setDeployed("1");
        table.setDeployedTime(LocalDateTime.now());
        this.update((Model)table);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deployDotHaveTable(String tableId, String tableSql, String detailTableSql) throws Exception {
        BizAppCatalogsTable table = (BizAppCatalogsTable)this.get((Serializable)((Object)tableId));
        if ("1".equals(table.getDeployed())) {
            throw new ApplicationException("\u8868\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u4ece\u91cd\u590d\uff0c\u5982\u679c\u6709\u95ee\u9898\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        List<BizAppCatalogsTableField> tableFields = this.appCatalogsTableFieldManager.queryFieldByTableId(tableId);
        if (tableFields.size() == 0) {
            throw new ApplicationException("\u8868\u5185\u6ca1\u6709\u5b57\u6bb5\u4e0d\u80fd\u53d1\u5e03");
        }
        table.setCreateTableSql(tableSql);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"app");
        table.setIsCreateTable("1");
        table.setDeployed("1");
        table.setDeployedTime(LocalDateTime.now());
        table.setCreateTableSql(tableSql);
        if ("2".equals(table.getTableClass())) {
            table.setCreateTableDSql(detailTableSql);
            template.execute(table.getCreateTableDSql());
        }
        template.execute(table.getCreateTableSql());
        this.update((Model)table);
    }

    @Override
    public boolean checkTableExists(String tableNameEn) throws Exception {
        String sql;
        tableNameEn = "app_" + tableNameEn;
        if (this.checkTable(tableNameEn)) {
            return true;
        }
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"app");
        return (Integer)template.queryForObject(sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'", Integer.class) > 0;
    }

    @Override
    public boolean saveInfo(BizAppCatalogsTable table) {
        table.setIsCreateTable("0");
        table.setDeployed("0");
        table.setIsDele("0");
        return this.save((Object)table);
    }

    @Override
    public boolean checkPhysicsTableExists(String tableNameEn) throws Exception {
        String sql;
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"app");
        return (Integer)template.queryForObject(sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'", Integer.class) > 0;
    }

    @Override
    public Map<String, String> queryAppTable(String tableId) {
        BizAppCatalogsTable table = (BizAppCatalogsTable)this.get((Serializable)((Object)tableId));
        HashMap<String, String> result = new HashMap<String, String>();
        String tableDesc = table.getTableDesc() == null ? table.getTableNameCh() : table.getTableDesc();
        String appMainSql = DorisUtils.queryAppMainSql(table.getTableNameEn(), tableDesc);
        String appDetailSql = DorisUtils.queryAppDetailSql(table.getTableNameEn(), tableDesc);
        result.put("appMainSql", appMainSql);
        result.put("appDetailSql", appDetailSql);
        return result;
    }

    @Override
    @Transactional
    public QueryResultData queryDTTableData(QueryParamVo queryParamVo) throws Exception {
        if (StringUtil.isEmpty((String)queryParamVo.getTableId()) && StringUtil.isEmpty((String)queryParamVo.getTableName())) {
            throw new ApplicationException("\u8868ID\u6216\u8005\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryParam queryParam = new QueryParam();
        BeanUtils.copyNotNullProperties((Object)queryParam, (Object)queryParamVo);
        BizAppCatalogsTable table = null;
        if (StringUtil.isNotEmpty((String)queryParam.getTableId())) {
            table = (BizAppCatalogsTable)((Object)this.getById((Serializable)((Object)queryParam.getTableId())));
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TABLE_NAME_EN_", (Object)queryParamVo.getTableName());
            table = (BizAppCatalogsTable)((Object)((BizAppCatalogsTableDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        }
        if (table == null) {
            return null;
        }
        queryParam.setTableName(table.getTableNameEn());
        List<BizAppCatalogsTableField> fieldList = this.appCatalogsTableFieldManager.queryFieldByTableId(table.getId());
        Map<String, String> field = fieldList.stream().filter(p -> "2".equals(p.getFieldType())).collect(Collectors.toMap(BizAppCatalogsTableField::getFieldCode, p -> p.getName()));
        field.put("id_", "\u4e3b\u952e");
        if (queryParam.getPageNo() == 0) {
            field = fieldList.stream().collect(Collectors.toMap(BizAppCatalogsTableField::getFieldCode, p -> p.getName()));
        }
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"app");
        Integer pageNo = queryParamVo.getPageNo();
        Integer pageSize = queryParamVo.getPageSize();
        String order = queryParamVo.getOrder();
        String tableName = table.getTableNameEn();
        Map<String, String> paramMap = queryParamVo.getParam();
        tableName = tableName.replace("dw_", "");
        QueryResultData resultData = new QueryResultData();
        String mainTable = "APP_D_" + tableName;
        String recordTable = "APP_D_" + tableName + "_COLUMN";
        String querySql = "select * from " + mainTable + " where 1=1";
        String querySqlCount = "select count(*) from " + recordTable + " where 1=1";
        for (String key : paramMap.keySet()) {
            querySql = querySql + " and " + key + " = '" + paramMap.get(key) + "'";
            querySqlCount = querySqlCount + " and " + key + " = '" + paramMap.get(key) + "'";
        }
        if (pageNo > 0) {
            int total = (Integer)template.queryForObject(querySqlCount, Integer.class);
            resultData.setTotal(total);
        }
        querySql = StringUtil.isNotEmpty((String)order) ? querySql + " order by " + order : querySql + " order by create_time_";
        if (pageNo > 1) {
            querySql = querySql + " limit " + (pageNo - 1) * pageSize + "," + pageSize;
        }
        resultData.setData(template.queryForList(querySql));
        resultData.setField(field);
        return resultData;
    }

    @Override
    public Map<String, Object> queryTableDetailData(String tableId, String pcId) throws Exception {
        BizAppCatalogsTable table = (BizAppCatalogsTable)((Object)this.getById((Serializable)((Object)tableId)));
        String tableName = table.getTableNameEn().replace("app_", "");
        List<BizAppCatalogsTableField> fieldList = this.appCatalogsTableFieldManager.queryFieldByTableId(tableId);
        String querySql = "select * from DWD_" + tableName + "_TABLE_RECORD where DATA_ID_= ? ";
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"app");
        List data = template.queryForList(querySql, new Object[]{pcId});
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("data", data);
        result.put("field", fieldList);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateCatalog(String[] ids, String catalogId) {
        int count = ((BizAppCatalogsTableDao)this.baseMapper).updateCatalog(ids, catalogId);
        return count > 0;
    }
}

