import req from '@/request.js'
const portal = window.context.portal
export default {
	// 添加
	addData(data, cb) {
		req.post(portal + `/qf/euro/rates/`, data).then(res => {
			cb(res.data)
		})
	},
	//修改
	editData(data, cb) {
		req.put(portal + `/qf/euro/rates/detail/batchUpdate`, data).then(res => {
			cb(res.data)
		})
	},
	//删除
	delDate(ids, cb) {
		req.remove(portal + `/qf/euro/rates/?ids=` + ids).then(res => {
			cb(res.data)
		})
	},
	//查询
	pageQuery(data, cb) {
		req.post(portal + `/qf/euro/rates/query`, data).then(res => {
			cb(res.data)
		})
	},

	// id查询
	detailId(id, cb) {
		req.get(portal + `/qf/euro/rates/` + id).then(rep => {
			cb(rep.data)
		})
	},
	//修改状态
	editStatus(data, cb) {
		req.put(portal + `/qf/euro/rates/updateStatus`, data).then(res => {
			cb(res.data)
		})
	},
	//导入
	importExcel(data, cb) {
		req.post(portal + `/qf/euro/rates/importExcel`, data).then(res => {
			cb(res.data)
		})
	},
	//导出
	export (data, cb) {
		req.post(portal + `/qf/euro/rates/export`, data,'blob').then(res => {
			cb(res.data)
		})
	},
	/*二级页面*/
	//批量添加
	saveData(data, cb) {
		req.put(portal + `/qf/euro/rates/detail/batchUpdate`, data).then(res => {
			cb(res.data)
		})
	},
	//表格查询
	detailQuery(data, cb) {
		req.post(portal + `/qf/euro/rates/detail/detailQuery`, data).then(res => {
			cb(res.data)
		})
	},
	//批量删除
	dleDetail(ids, cb) {
		req.remove(portal + `/qf/euro/rates/detail/?ids=` + ids).then(res => {
			cb(res.data)
		})
	},

}
