/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.projectManagement.manager.impl;

import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.cqxy.projectManagement.dao.ProjectPersonnelMenuDao;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelMenuManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.projectManagement.model.ProjectPersonnelMenu;
import com.artfess.cqxy.projectManagement.vo.ProjectPersonnelMenuVo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.sysConfig.persistence.manager.SysMenuManager;
import com.artfess.sysConfig.persistence.model.SysMenu;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ProjectPersonnelMenuManagerImpl
extends BaseManagerImpl<ProjectPersonnelMenuDao, ProjectPersonnelMenu>
implements ProjectPersonnelMenuManager {
    @Resource
    private ProjectPersonnelMenuDao projectPersonnelMenuDao;
    @Resource
    private SysMenuManager sysMenuManager;
    @Resource
    private UCFeignService uCFeignService;
    @Value(value="${system.mode.demo:false}")
    protected boolean demoMode;
    @Autowired
    private SaaSConfig saaSConfig;
    @Resource
    private MultiTenantHandler multiTenantHandler;
    @Resource
    private BaseContext baseContext;
    @Resource
    private ProjectManagementManager projectManagementManager;

    @Override
    public void create(ProjectPersonnelMenuVo projectPersonnelMenuVo) {
        ((ProjectPersonnelMenuDao)this.baseMapper).removeByProjectIdAndUserId(projectPersonnelMenuVo.getProjectId(), projectPersonnelMenuVo.getUserId());
        List<String> arrMenuAlias = projectPersonnelMenuVo.getArrMenuAlias();
        ProjectPersonnelMenu projectPersonnelMenu = new ProjectPersonnelMenu();
        projectPersonnelMenu.setProjectId(projectPersonnelMenuVo.getProjectId());
        projectPersonnelMenu.setUserlId(projectPersonnelMenuVo.getUserId());
        for (String menuAlias : arrMenuAlias) {
            projectPersonnelMenu.setId(UniqueIdUtil.getSuid());
            projectPersonnelMenu.setMenuAlias(menuAlias);
            ((ProjectPersonnelMenuDao)this.baseMapper).insert((Object)projectPersonnelMenu);
        }
        projectPersonnelMenu.setMenuAlias(null);
        List<String> arrMethodAlias = projectPersonnelMenuVo.getArrMethodAlias();
        Map<String, String> dataPermission = projectPersonnelMenuVo.getDataPermission();
        for (String methodAlias : arrMethodAlias) {
            projectPersonnelMenu.setId(UniqueIdUtil.getSuid());
            projectPersonnelMenu.setMethodAlias(methodAlias);
            projectPersonnelMenu.setDataPermission(dataPermission.get(methodAlias));
            ((ProjectPersonnelMenuDao)this.baseMapper).insert((Object)projectPersonnelMenu);
        }
    }

    @Override
    public List<Map<String, Object>> getAllMenuByProject(String projectId, String userId, String status) throws Exception {
        List result = this.sysMenuManager.getAllMenuRoleAlias(projectId, userId, status);
        return result;
    }

    @Override
    public List<SysMenu> getCurrentUserMenuByProject(String projectId, String menuAlias) throws Exception {
        ArrayList<String> projectManagerIdList;
        Boolean isAdmin = false;
        ProjectManagement project = (ProjectManagement)((Object)this.projectManagementManager.getById((Serializable)((Object)projectId)));
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01");
        }
        String currentUserId = currentUser.getUserId();
        String projectManagerId = project.getProjectManagerId();
        List<String> menuList = null;
        if (StringUtils.isNotBlank((CharSequence)projectManagerId) && (projectManagerIdList = new ArrayList<String>(Arrays.asList(projectManagerId.split(",")))).contains(currentUserId)) {
            isAdmin = true;
        }
        if (!isAdmin.booleanValue()) {
            menuList = this.projectPersonnelMenuDao.queryAliasByProjectIdAndUserId(projectId, currentUserId);
        }
        List<SysMenu> lists = this.sysMenuManager.getCurrentUserMenuByProject(isAdmin, menuList, currentUser);
        lists = this.i18nSysMenu(lists);
        List result = this.sysMenuManager.filterByMenuAlias(menuAlias, lists);
        return result;
    }

    private List<SysMenu> i18nSysMenu(List<SysMenu> lists) {
        ArrayList<String> i18nKey = new ArrayList<String>();
        for (SysMenu sysMenu : lists) {
            i18nKey.add(sysMenu.getAlias());
        }
        Map messages = I18nUtil.getMessages(i18nKey, (Locale)LocaleContextHolder.getLocale());
        for (SysMenu sysMenu : lists) {
            String key = sysMenu.getAlias();
            if (!messages.containsKey(key) || !StringUtil.isNotEmpty((String)((String)messages.get(key))) || key.equals(messages.get(key))) continue;
            sysMenu.setName((String)messages.get(key));
        }
        return lists;
    }
}

