package com.artfess.cqxy.search.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.search.dao.GlobalRetrievalDao;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * 档案全局检索表(BizGlobalRetrieval)表服务实现类
 *
 * @author 黎沐华
 * @since 2022-03-22 13:13:33
 */
@Service
public class GlobalRetrievalManagerImpl extends BaseManagerImpl<GlobalRetrievalDao, GlobalRetrieval> implements GlobalRetrievalManager {

    @Override
    public PageList<GlobalRetrieval> queryAllByPage(QueryFilter<GlobalRetrieval> queryFilter) {
        IPage<GlobalRetrieval> result =
                baseMapper.queryAllByPage(
                        convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public GlobalRetrieval getByBizId(String bizId) {
        return this.baseMapper.geByBizId(bizId);
    }

    @Override
    public boolean remove(Integer type, String id) {
        return baseMapper.remove(type,id)>0;
    }

    @Override
    public boolean saveOrUpdate(GlobalRetrieval entity){
        if(StringUtils.isEmpty(entity.getId())){
            return baseMapper.insert(entity)>0;
        }else{
            return baseMapper.update(entity)>0;
        }
    }
}

