package com.artfess.cqxy.wps.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author 黎沐华
 * @date 2022/4/26 16:05
 */
public enum FileTypeEnum {
    w("w","doc, dot, wps, wpt, docx, dotx, docm, dotm, rtf"),
    s("s","xls, xlt, et, xlsx, xltx, csv, xlsm, xltm"),
    p("p","ppt, pptx, pptm, ppsx, ppsm, pps, potx, potm, dpt, dps"),
    f("f","pdf")
    ;
    private String type;
    private String surffix;

    FileTypeEnum(String type, String surffix) {
        this.type = type;
        this.surffix = surffix;
    }

    public static String getTypeBySuffix(String surffix){
        if(StringUtils.isEmpty(surffix)){
            return null;
        }
        FileTypeEnum[] values = values();
        for (FileTypeEnum ele : values) {
            if (ele.surffix.contains(surffix)) {
                return ele.type;
            }
        }
        throw new RuntimeException("WPS 在线文档服务不支持此文件x类型："+surffix);
    }

}
