package com.artfess.cqxy.projectManagement.vo;

import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;


@ApiModel(description = "项目合并VO对象")
@Data
public class MergeItemsVo {

    @ApiModelProperty(name = "projectIds", notes = "需要合并的项目ID，多个使用逗号隔开")
    private String projectIds;

    @ApiModelProperty(name = "parentId", notes = "需要合并至已有项目的ID，合并成新项目则不传ID")
    private String parentId;

    @ApiModelProperty(name = "projectManagement", notes = "合并成新项目时的项目对象")
    private ProjectManagement projectManagement;
}
