package com.artfess.cqxy.processManagermant.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 过程管理 - 质量管理-质量整改(BizQualityRectification)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-03 16:27:05
 */
@TableName("BIZ_QUALITY_RECTIFICATION")
@ApiModel(value="过程管理-质量管理-质量整改对象-ChangeManagement", description="过程管理-质量管理-质量整改表")
public class QualityRectification extends BizModel<QualityRectification> {

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "整改编号")
    @TableField("RECTIFICATION_CODE_")
    @ApiModelProperty(value = "整改编号，（由后台生成，生成格式：ZLZG+年月日+01，01表示按天自增）")
    private String rectificationCode;

    @Excel(name = "整改时间",format = "yyyy-MM-dd")
    @TableField("RECTIFICATION_DATE_")
    @ApiModelProperty(value = "整改时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rectificationDate;

    @Excel(name = "部位")
    @TableField("RECTIFICATION_POSITION_")
    @ApiModelProperty(value = "部位")
    private String rectificationPosition;

    @Excel(name = "整改内容")
    @TableField("RECTIFICATION_CONTENT_")
    @ApiModelProperty(value = "整改内容")
    private String rectificationContent;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

//    @Excel(name = "质量问题")
    @TableField("QUALITY_PROBLEM_")
    @ApiModelProperty(value = "质量问题")
    private String qualityProblem;

    @TableField("ASSIGN_USER_ID_")
    @ApiModelProperty(value = "指派人员ID")
    private String assignUserId;

//    @Excel(name = "指派人员姓名")
    @TableField("ASSIGN_USER_NAME_")
    @ApiModelProperty(value = "指派人员姓名")
    private String assignUserName;

//    @Excel(name = "指派时间",format = "yyyy-MM-dd")
    @TableField("ASSIGN_DATE_")
    @ApiModelProperty(value = "指派时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date assignDate;

//    @Excel(name = "整改情况反馈")
    @TableField("RECTIFICATION_SITUATION_")
    @ApiModelProperty(value = "整改情况反馈")
    private String rectificationSituation;

    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "QualityRectification{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", rectificationCode='" + rectificationCode + '\'' +
                ", rectificationPosition='" + rectificationPosition + '\'' +
                ", qualityProblem='" + qualityProblem + '\'' +
                ", rectificationContent='" + rectificationContent + '\'' +
                ", assignUserId='" + assignUserId + '\'' +
                ", assignUserName='" + assignUserName + '\'' +
                ", assignDate=" + assignDate +
                ", rectificationDate=" + rectificationDate +
                ", rectificationSituation='" + rectificationSituation + '\'' +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getRectificationCode() {
        return rectificationCode;
    }

    public void setRectificationCode(String rectificationCode) {
        this.rectificationCode = rectificationCode;
    }

    public String getRectificationPosition() {
        return rectificationPosition;
    }

    public void setRectificationPosition(String rectificationPosition) {
        this.rectificationPosition = rectificationPosition;
    }

    public String getQualityProblem() {
        return qualityProblem;
    }

    public void setQualityProblem(String qualityProblem) {
        this.qualityProblem = qualityProblem;
    }

    public String getRectificationContent() {
        return rectificationContent;
    }

    public void setRectificationContent(String rectificationContent) {
        this.rectificationContent = rectificationContent;
    }

    public String getAssignUserId() {
        return assignUserId;
    }

    public String getRectificationSituation() {
        return rectificationSituation;
    }

    public void setRectificationSituation(String rectificationSituation) {
        this.rectificationSituation = rectificationSituation;
    }

    public void setAssignUserId(String assignUserId) {
        this.assignUserId = assignUserId;
    }

    public String getAssignUserName() {
        return assignUserName;
    }

    public void setAssignUserName(String assignUserName) {
        this.assignUserName = assignUserName;
    }

    public Date getAssignDate() {
        return assignDate;
    }

    public void setAssignDate(Date assignDate) {
        this.assignDate = assignDate;
    }

    public Date getRectificationDate() {
        return rectificationDate;
    }

    public void setRectificationDate(Date rectificationDate) {
        this.rectificationDate = rectificationDate;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public ProjectManagement getProjectInfo() {
        return projectInfo;
    }

    public void setProjectInfo(ProjectManagement projectInfo) {
        this.projectInfo = projectInfo;
    }

    public List<Accessory> getAccessoryInfo() {
        return accessoryInfo;
    }

    public void setAccessoryInfo(List<Accessory> accessoryInfo) {
        this.accessoryInfo = accessoryInfo;
    }
}

