package com.artfess.cqxy.processManagermant.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.processManagermant.model.ProgressManageReport;
import com.artfess.cqxy.processManagermant.manager.ProgressManageReportManager;
import com.artfess.cqxy.processManagermant.vo.AppropriatedlVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;

/**
 * 过程管理 - 进度管理 - 工程月报(BizProgressManageReport)表控制层
 *
 * @author 黎沐华
 * @since 2022-03-11 17:46:50
 */
@Slf4j
@RestController
@Api(tags = "施工管理-进度管理-工程月报接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/processManagement/progressManageReport/v1")
public class ProgressManageReportController extends BaseController<ProgressManageReportManager, ProgressManageReport> {

    /**
     * 保存或修改数据
     * @param progressManageReport 实体对象
     * @return 新增或更新结果
     */
    @PostMapping("/save")
    @ApiOperation(value = "S-保存或修改数据",httpMethod = "POST")
    public CommonResult insert(@RequestBody ProgressManageReport progressManageReport) {
        log.debug("工程月报-保存或修改数据接口请求参数：{}", progressManageReport);
        Assert.notNull(progressManageReport.getProjectId(),"项目ID不能为空");
        progressManageReport.setPortType("2");
        boolean add = StringUtils.isEmpty(progressManageReport.getId());


        String imageProgress = progressManageReport.getImageProgress();

        String replaceAll = imageProgress.replaceAll("%", "");

        progressManageReport.setImageProgress(replaceAll);
        if(null == progressManageReport.getPortDate()){
            progressManageReport.setPortDate(new Date());
        }

        if(progressManageReport.getProjectOvervie() == null || progressManageReport.getProjectOvervie().compareTo(BigDecimal.ZERO) == 0){
            //重新计算一次总投资金额
            Date portDate = progressManageReport.getPortDate();

            SimpleDateFormat syd = new SimpleDateFormat("yyyy-MM-dd");
            BigDecimal result = baseService.getInvestmentTotal(progressManageReport.getProjectId(), syd.format(portDate), progressManageReport.getContractId());
            //累加本次的审定支付金额
//            if(null != progressManageReport.getProgressDescription()){
//                result = result.add(progressManageReport.getProgressDescription());
//            }
            progressManageReport.setProjectOvervie(result);
        }
        boolean save = baseService.saveOrUpdate(progressManageReport);
        //当数据更新或者添加数据不是正常顺序时，异步修改当前日期及以后的累计总投资
        baseService.updateProjectOvervie(progressManageReport);
        String msg = (add ? "添加" : "修改")+(save ? "成功" : "失败");
        log.debug("工程月报-保存或修改数据接口响应结果：{}", msg);
        return new CommonResult(save, msg);
    }




    /**
     * 批量导入Excel数据
     * @param file Excel文件
     */
    @PostMapping("/importExcelData")
    @ApiOperation(value = "S-批量导入Excel数据")
    public CommonResult importExcelData (@ApiParam("上传文件") @RequestParam("file") MultipartFile file,
                                         @ApiParam("项目ID") @RequestParam("projectId") String projectId,
                                         @ApiParam("合同ID") @RequestParam("contractId") String contractId/**,
                                         Integer portType, Integer portUnit, String portUserName,String portDate**/){
        log.debug("批量导入Excel数据接口请求参数：{}",file, projectId,contractId);
        baseService.importExcelData(file, projectId,contractId);
        return new CommonResult<>("导入成功");
    }

    /**
     * 导出数据到Excel
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportDataToExcel")
    @ApiOperation(value = "S-导出数据到Excel",notes = "参数说明：查询器只使到了query组传参，其他都可以不要，查询条件要带上表别名：主表 bpmr、副表 pm；传入pm.ID_导出该项目下的数据，否则将导出所有数据")
    public CommonResult exportDataToExcel (@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<ProgressManageReport> queryFilter, HttpServletResponse response) throws IOException {
        log.debug("导出数据到Excel接口请求参数：{}",queryFilter,response);
        baseService.exportDatatoExcel(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

    /**
     * 删除数据
     * @param ids 主键集合
     * @return 删除结果
     */
    @PostMapping("/delete")
    @ApiOperation(value = "S-删除数据",httpMethod = "POST")
    public CommonResult delete(@ApiParam(name = "ids",value = "ID集合") @RequestParam("ids") String ids) {
        log.debug("工程月报-删除数据接口请求参数：{}", ids);
        Assert.notNull(ids,"主键集合不能为空");
        boolean state = baseService.deleteByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "删除成功" : "删除失败";
        log.debug("工程月报-删除数据接口响应结果：{}", msg);
        return new CommonResult<String>(state, msg);
    }

    /**
     * 通过主键查询单条数据
     * @param id 主键
     * @return 单条数据
     */
    @PostMapping("/detail/{id}")
    @ApiOperation(value = "S-根据ID查询详情",httpMethod = "POST")
    public CommonResult<ProgressManageReport> selectOne(@ApiParam(name = "id",value = "主键ID") @PathVariable String id) {
        log.debug("工程月报-根据ID查询详情 接口请求参数：{}", id);
        Assert.notNull(id,"主键不能为空");
        ProgressManageReport result = baseService.getById(id);
        boolean state = !BeanUtils.isEmpty(result);
        log.debug("工程月报-根据ID查询详情 接口响应结果：{}", result);
        return new CommonResult<ProgressManageReport>(state, state?"操作成功":"该ID没有对应数据", result);
    }

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询所有数据",notes = "参数说明：在通用查询器中的query对象组传入查询参数，传入 PROJECT_ID_ 项目ID 以切换项目，所有参数都需要带上表别名——主表为bpmr、副表为pm",httpMethod = "POST")
    public CommonResult<PageList<ProgressManageReport>> selectAll(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<ProgressManageReport> queryFilter) {
        log.debug("工程月报-分页查询所有数据接口请求参数：{}", queryFilter);
        PageList<ProgressManageReport> result = baseService.queryAllByPage(queryFilter);
        log.debug("工程月报-分页查询所有数据接口响应结果：{}", result);
        return new CommonResult<>(true,"操作成功",result);
    }

    @PostMapping("/getInvestmentTotal")
    @ApiOperation(value = "S-根据项目ID获取累计总投资",httpMethod = "POST")
    public CommonResult<BigDecimal> getInvestmentTotal(@ApiParam(name = "appropriatedlVo",value = "已拨款额查询参数VO")
                                                           @RequestBody AppropriatedlVo appropriatedlVo) {
        Assert.notNull(appropriatedlVo, "参数不能为空！");
        Assert.notNull(appropriatedlVo.getProjectId(), "项目ID不能为空！");
        BigDecimal result = baseService.getInvestmentTotal(appropriatedlVo.getProjectId(), appropriatedlVo.getRegisterDate(), appropriatedlVo.getContractId());
        return new CommonResult<BigDecimal>(true, "累计总投资查询成功", result.stripTrailingZeros() );
    }


    @PostMapping("/recalManageReport")
    @ApiOperation(value = "多线程重算工程月报",httpMethod = "POST")
    public void recalManage(String projectId) {
        baseService.recalManageReport(projectId);

    }

}

