package com.artfess.cqxy.ledger.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.completionAcceptance.model.AcceptanceFinalAccounts;
import com.artfess.cqxy.feasiblePlan.model.PlanningSelectionSite;
import com.artfess.cqxy.ledger.vo.ProjectLedgerVo;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @author Limuhua
 * @date 2022/3/15 15:33
 */
public interface ProjectLedgerManager{

    /**
     * 获取所有分类数据
     * @return 分类数据Map
     */
    List<Map<String, String>> getCollect(QueryFilter<ProjectManagement> queryFilter);

    /**
     * 获取分类下的详细数据
     * @param queryFilter 项目管理查询器
     * @return 数据集合
     */
    Map<String, Object> getDataByPage(QueryFilter<ProjectManagement> queryFilter);

    /**
     * 导出数据到Excel
     * @param queryFilter 项目管理查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDatatoExcel(QueryFilter<ProjectManagement> queryFilter, HttpServletResponse response) throws Exception;

}
