package com.artfess.cqxy.documentLibrary.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 文件库-分类表(FileLibraryType)表实体类
 *
 * @author 黎沐华
 * @since 2022-04-02 09:21:22
 */
@Data
@TableName("BIZ_FILE_LIBRARY_TYPE")
@ApiModel(value="文件库-分类表对象-FileLibrary", description="文件库-分类表表")
public class FileLibraryType extends BizModel<FileLibraryType> {

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("NAME_")
    @ApiModelProperty(value = "分类名称")
    private String name;

    @TableField("CODE_")
    @ApiModelProperty(value = "分类编码")
    private String code;

    @TableField("PCODE_")
    @ApiModelProperty(value = "父节点ID")
    private String pcode;

    @TableField("HAS_CHILDREN_")
    @ApiModelProperty(value = "是否有子分类（0：有，1：没有，后台在数据增、删、改时自动计算）")
    private Integer hasChildren;

    @TableField(exist = false)
    @ApiModelProperty(value = "子节点数据")
    private List<FileLibraryType> children;

}

