package com.artfess.cqxy.documentLibrary.dao;

import java.util.List;

import com.artfess.cqxy.designEstimate.model.AquaticProtection;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.documentLibrary.model.FileLibrary;

/**
 * 文件库表(FileLibrary)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-04-02 09:22:25
 */
public interface FileLibraryDao extends BaseMapper<FileLibrary> {

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<FileLibrary> queryAllByPage(IPage<FileLibrary> convert2IPage, @Param(Constants.WRAPPER) Wrapper<FileLibrary> convert2Wrapper);

}
