package com.artfess.cqxy.designEstimate.dao;

import com.artfess.cqxy.designEstimate.model.AquaticProtection;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 设计概算 - 水保表(BizAquaticProtection)表数据库访问层
 * @author 黎沐华
 * @since 2022-02-16 15:12:08
 */
public interface AquaticProtectionDao extends BaseMapper<AquaticProtection> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    AquaticProtection getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<AquaticProtection> queryAllByPage(IPage<AquaticProtection> convert2IPage, @Param(Constants.WRAPPER) Wrapper<AquaticProtection> convert2Wrapper);

}

