package com.artfess.cqxy.completionAcceptance.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 竣工验收 - 预验收表（暂定）(BizPreAcceptance)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-07 11:41:48
 */
@TableName("BIZ_PRE_ACCEPTANCE")
@ApiModel(value="竣工验收-预验收对象-PreAcceptance", description="预验收表")
public class PreAcceptance extends BizModel<PreAcceptance> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "验收时间",format = "yyyy-MM-dd")
    @TableField("PLAN_ACCEPTANCE_DATE_")
    @ApiModelProperty(value = "验收时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planAcceptanceDate;

    @Excel(name = "验收地点")
    @TableField("PRE_ACCEPTANCE_UNIT_")
    @ApiModelProperty(value = "验收地点")
    private String preAcceptanceUnit;

    @Excel(name = "验收主题")
    @TableField("PRE_ACCEPTANCE_PERSON_ID_")
    @ApiModelProperty(value = "验收会议主题")
    private String preAcceptancePersonId;

    @Excel(name = "参加单位")
    @TableField("PRE_SUF_REASON_")
    @ApiModelProperty(value = "参加单位")
    private String preSufReason;

    @Excel(name = "经办人")
    @TableField("PRE_ACCEPTANCE_PERSON_NAME_")
    @ApiModelProperty(value = "经办人，（默认值为：项目负责人）")
    private String preAcceptancePersonName;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

//    @Excel(name = "实际交工时间",format = "yyyy-MM-dd")
    @TableField("ACTUAL_ACCEPTANCE_DATE_")
    @ApiModelProperty(value = "实际交工时间-暂不使用")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualAcceptanceDate;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "PreAcceptance{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", preAcceptancePersonId='" + preAcceptancePersonId + '\'' +
                ", preAcceptancePersonName='" + preAcceptancePersonName + '\'' +
                ", preAcceptanceUnit='" + preAcceptanceUnit + '\'' +
                ", planAcceptanceDate=" + planAcceptanceDate +
                ", actualAcceptanceDate=" + actualAcceptanceDate +
                ", preSufReason='" + preSufReason + '\'' +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getPreAcceptancePersonId() {
        return preAcceptancePersonId;
    }

    public void setPreAcceptancePersonId(String preAcceptancePersonId) {
        this.preAcceptancePersonId = preAcceptancePersonId;
    }

    public String getPreAcceptancePersonName() {
        return preAcceptancePersonName;
    }

    public void setPreAcceptancePersonName(String preAcceptancePersonName) {
        this.preAcceptancePersonName = preAcceptancePersonName;
    }

    public String getPreAcceptanceUnit() {
        return preAcceptanceUnit;
    }

    public void setPreAcceptanceUnit(String preAcceptanceUnit) {
        this.preAcceptanceUnit = preAcceptanceUnit;
    }

    public Date getPlanAcceptanceDate() {
        return planAcceptanceDate;
    }

    public void setPlanAcceptanceDate(Date planAcceptanceDate) {
        this.planAcceptanceDate = planAcceptanceDate;
    }

    public Date getActualAcceptanceDate() {
        return actualAcceptanceDate;
    }

    public void setActualAcceptanceDate(Date actualAcceptanceDate) {
        this.actualAcceptanceDate = actualAcceptanceDate;
    }

    public String getPreSufReason() {
        return preSufReason;
    }

    public void setPreSufReason(String preSufReason) {
        this.preSufReason = preSufReason;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public ProjectManagement getProjectInfo() {
        return projectInfo;
    }

    public void setProjectInfo(ProjectManagement projectInfo) {
        this.projectInfo = projectInfo;
    }

    public List<Accessory> getAccessoryInfo() {
        return accessoryInfo;
    }

    public void setAccessoryInfo(List<Accessory> accessoryInfo) {
        this.accessoryInfo = accessoryInfo;
    }
}

