package com.artfess.cqxy.completionAcceptance.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 竣工验收 - 结算表(BizAcceptanceSettlement)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-07 15:15:05
 */
@TableName("BIZ_ACCEPTANCE_SETTLEMENT")
@ApiModel(value="竣工验收-结算对象-ChangeManagement", description="竣工验收-结算表")
@Data
public class AcceptanceSettlement extends BizModel<AcceptanceSettlement> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

//    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的合同信息")
    private Contract contractInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @TableField("CONTRACT_ID_")
    @ApiModelProperty(value = "合同ID（关联合同表ID）")
    private String contractId;

    @TableField("CONTRACT_NAME_")
    @ApiModelProperty(value = "合同名称（关联合同表合同名称）")
    private String contractName;

    @Excel(name = "结算单位")
    @TableField("FILING_AUTHORITY_OPINIONS_")
    @ApiModelProperty(value = "结算单位")
    private String filingAuthorityOpinions;

    @Excel(name = "结算金额(元)")
    @TableField("FILING_AUTHORITY_REGISTRANT_")
    @ApiModelProperty(value = "结算金额(元)")
    private BigDecimal filingAuthorityRegistrant;

    @Excel(name = "经办人")
    @TableField("HANDLER_")
    @ApiModelProperty(value = "经办人")
    private String handler;

    @Excel(name = "审批意见")
    @TableField("APPROVAL_OPINION_")
    @ApiModelProperty(value = "备案机关审批意见")
    private String approvalOpinion;

    @Excel(name = "结算时间",format = "yyyy-MM-dd")
    @TableField("FILING_AUTHORITY_DATE_")
    @ApiModelProperty(value = "结算时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date filingAuthorityDate;


    @Excel(name = "工程结算一审审核金额（元）", type = 10, numFormat = "0.00")
    @TableField("FIRST_INSTANCE_PRICE_")
    @ApiModelProperty(value = "工程结算一审审核金额（元）")
    private BigDecimal firstInstancePrice;

    @Excel(name = "工程结算二审审核金额（元）", type = 10, numFormat = "0.00")
    @TableField("SECOND_INSTANCE_PRICE_")
    @ApiModelProperty(value = "工程结算二审审核金额（元）")
    private BigDecimal secondInstancePrice;


    @Excel(name = "结算报送时间",format = "yyyy-MM-dd")
    @TableField("FILING_AUTHORITY_SEND_DATE_")
    @ApiModelProperty(value = "结算报送时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date filingAuthoritySendDate;

    @Excel(name = "结算报送金额(元)", type = 10, numFormat = "0.00")
    @TableField("FILING_AUTHORITY_REGISTRANT_SEND_")
    @ApiModelProperty(value = "结算报送金额(元)")
    private BigDecimal filingAuthorityRegistrantSend;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;


}

