/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ljzc.fixed.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.ljzc.fixed.manager.BizAssetFixedInfoManager;
import com.artfess.ljzc.fixed.model.BizAssetFixedInfo;
import com.artfess.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u56fa\u5b9a\u8d44\u4ea7-\u8d44\u4ea7\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/biz/assetFixedInfo/v1/"})
@ApiGroup(group={"group_biz"})
public class BizAssetFixedInfoController
extends BaseController<BizAssetFixedInfoManager, BizAssetFixedInfo> {
    private static final Logger log = LoggerFactory.getLogger(BizAssetFixedInfoController.class);

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizAssetFixedInfo t) {
        boolean result = ((BizAssetFixedInfoManager)this.baseService).createInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public BizAssetFixedInfo getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizAssetFixedInfoManager)this.baseService).findById(id);
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizAssetFixedInfo> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizAssetFixedInfo> queryFilter) {
        String fullId = ContextUtil.getCurrentOrgFullId();
        queryFilter.addFilter("belongs_org_full_id_", (Object)fullId, QueryOP.RIGHT_LIKE);
        return ((BizAssetFixedInfoManager)this.baseService).findByPage(queryFilter);
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={UpdateGroup.class}) @RequestBody BizAssetFixedInfo t) {
        boolean result = ((BizAssetFixedInfoManager)this.baseService).updateInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((BizAssetFixedInfoManager)this.baseService).removeInfo(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }
}

