package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 巡查类型
 */
@Getter
public enum InspectTypeEnum {
    /**
     * 删除
     */
    ONE("1", "往返"),

    TWO("2", "单程"),

    ;

    InspectTypeEnum(String type, String desc){
        this.desc = desc;
        this.type = type;
    }

    private String desc;

    private String type;

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        InspectTypeEnum[] values = values();
        for (InspectTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
