package com.artfess.base.constants;

import java.util.Arrays;
import java.util.List;

/**
 * 系统常量
 *
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2019年6月5日
 */
public interface SystemConstants {
	/**
	 * 超级管理员账号
	 */
	String SYSTEM_ACCOUNT = "admin";

	/**
	 * 系统管理员账号
	 */
	String SYS_ADMIN_ACCOUNT = "sysadmin";

	/**
	 * 安全管理员账号
	 */
	String SEC_ACCOUNT = "secadmin";

	/**
	 * 日志审计员账号
	 */
	String AUDIT_ACCOUNT = "audit";

	/**
	 * 游客账号
	 */
	String GUEST_ACCOUNT = "guest";
	
    String REFERER_FEIGN ="feign";

	/**
	 * 系统管理员角色
	 */
	String SYSTEM_ROLE = "sysRole";

	/**
	 * 安全管理员角色
	 */
	String SEC_ROLE = "secRole";

	/**
	 * 日志审计员角色
	 */
	String AUDIT_ROLE = "auditRole";

	/**
	 * 分级管理员角色
	 */
	String FJADMIN_ROLE = "fjRole";

	/**
	 * 中铁建昆仑高速公路运营管理有限公司ID
	 */
	String SYS_ORG_ID = "1766017468444450816";

	/**
	 * 各指挥部的ID
	 * 贵州，1867050112732372992
	 * 四川，1766017976202698752
	 * 云南 1766019322897244160
	 * 中铁建昆仑高速公路运营管理有限公司 1766017468444450816
	 */
	List<String> orgIds = Arrays.asList(
			"1867050112732372992",
			"1766017976202698752",
			"1766019322897244160"
	);
}
