package com.artfess.service.model;

import com.artfess.base.service.InvokeCmd;
import com.artfess.base.util.Base64;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 服务调用的参数对象
 * @author heyifan
 * @version 创建时间: 2014-8-18
 */
@ApiModel("service调用命令对象")
public class DefaultInvokeCmd implements InvokeCmd, Serializable{
	private static final long serialVersionUID = 1L;
	@ApiModelProperty("调用地址")
	private String address;
	@ApiModelProperty("服务的用户名")
	private String username;
	@ApiModelProperty("服务的用户密码")
	private String password;
	@ApiModelProperty("操作方法名")
	private String operatorName;
	@ApiModelProperty("操作的名称空间")
	private String operatorNamespace;
	@ApiModelProperty("操作的调用参数json")
	private String jsonParam;
	@ApiModelProperty("操作的调用参数xml")
	private String xmlParam;
	@ApiModelProperty("调用的服务类型")
	private String type = "webservice";
	@ApiModelProperty("是否添加xmlns")
	private Boolean needPrefix = false;
	@ApiModelProperty("命名空间前缀，默认为api")
	private String nsPrefix = "api";
	@ApiModelProperty("请求的jaxb对象")
	private Object jaxbObject;
	@ApiModelProperty("返回的jaxb对象类型")
	private Class<?> jaxbRespClass;
	@ApiModelProperty("SoapHeader的jaxb对象")
	private Object headerObject;
	@ApiModelProperty("Http请求的Headers")
	private Map<String, String> connHeaders = new HashMap<>();
	public String getAddress() {
		return address;
	}
	public void setAddress(String address) {
		this.address = address;
	}
	public String getUsername() {
		return username;
	}
	public void setUsername(String username) {
		this.username = username;
	}
	public String getPassword() {
		return password;
	}
	public void setPassword(String password) {
		this.password = password;
	}
	public String getOperatorName() {
		return operatorName;
	}
	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}
	public String getOperatorNamespace() {
		return operatorNamespace;
	}
	public void setOperatorNamespace(String operatorNamespace) {
		this.operatorNamespace = operatorNamespace;
	}
	public String getJsonParam() {
		return jsonParam;
	}
	public void setJsonParam(String jsonParam) {
		this.jsonParam = jsonParam;
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	public Boolean getNeedPrefix() {
		return needPrefix;
	}
	public void setNeedPrefix(Boolean needPrefix) {
		this.needPrefix = needPrefix;
	}
	public String getXmlParam() {
		return xmlParam;
	}
	public void setXmlParam(String xmlParam) {
		this.xmlParam = xmlParam;
	}
	public String getNsPrefix() {
		return nsPrefix;
	}
	public void setNsPrefix(String nsPrefix) {
		this.nsPrefix = nsPrefix;
	}
	public Object getJAXBObjectParam() {
		return jaxbObject;
	}
	public void setJAXBObjectParam(Object objParam) {
		this.jaxbObject = objParam;
	}
	public Class<?> getJAXBRespClass() {
		return jaxbRespClass;
	}
	public void setJAXBRespClass(Class<?> jaxbRespClass) {
		this.jaxbRespClass = jaxbRespClass;
	}
	public Map<String, String> getConnHeaders() {
		return connHeaders;
	}
	@Override
	public void addConnHeader(String name, String value) {
		connHeaders.put(name, value);
	}
	@Override
	public void addBasicAuthHeader(String username, String password) {
		try {
			String authorization = Base64.getBase64(username + ":" + password);
			connHeaders.put("Authorization", "Basic " + authorization);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	@Override
	public Object getJAXBObjectHeader() {
		return headerObject;
	}
	@Override
	public void setJAXBObjectHeader(Object objHeader) {
		this.headerObject = objHeader;
	}
}