/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.service.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.MapUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.persistence.manager.BpmCustomSignDataManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmReadRecordManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.workflow.runtime.params.CustomSignRevokeParam;
import com.artfess.workflow.runtime.service.RevokeService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParallelApproveRevokeService
implements RevokeService {
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmReadRecordManager bpmReadRecordManager;
    @Resource
    BpmCustomSignDataManager bpmCustomSignDataManager;

    @Override
    public void canRevoke(Map<String, Object> map, List<DefaultBpmCheckOpinion> list, String isReadRevoke) {
        String taskId = MapUtil.getString(map, (String)"taskId");
        if (StringUtil.isEmpty((String)taskId)) {
            return;
        }
        List<DefaultBpmCheckOpinion> afterSignOpinions = this.getOpinionBySignType(list, "AfterSign");
        if (afterSignOpinions.size() > 0) {
            ArrayList<String> opinionStatusList = new ArrayList<String>();
            opinionStatusList.add(OpinionStatus.AWAITING_CHECK.getKey());
            opinionStatusList.add(OpinionStatus.REJECT.getKey());
            opinionStatusList.add(OpinionStatus.SIGN_RECOVER_CANCEL.getKey());
            opinionStatusList.add(OpinionStatus.RETRACTED.getKey());
            opinionStatusList.add(OpinionStatus.REVOKER.getKey());
            if (this.hasOpinionWithStatus(afterSignOpinions, opinionStatusList).booleanValue()) {
                List approvalDatas;
                String toTaskId = this.bpmExeStackManager.getToTaskIdByFromTaskId(taskId);
                if (toTaskId == null && BeanUtils.isEmpty((Object)(approvalDatas = this.bpmCustomSignDataManager.getByInstIdAndStatus(afterSignOpinions.get(0).getProcInstId(), Arrays.asList("approval"))))) {
                    map.put("revoke", true);
                    return;
                }
                DefaultBpmCheckOpinion toTaskOpinion = this.getOpinionByTaskId(afterSignOpinions, toTaskId);
                if (toTaskOpinion != null) {
                    ArrayList<DefaultBpmCheckOpinion> toTaskOpinionList = new ArrayList<DefaultBpmCheckOpinion>();
                    toTaskOpinionList.add(toTaskOpinion);
                    if (this.hasOpinionWithStatus(toTaskOpinionList, opinionStatusList).booleanValue()) {
                        this.setRevoke(map, toTaskId, isReadRevoke, this.bpmReadRecordManager);
                    }
                }
            }
        } else {
            map.put("revoke", true);
        }
    }

    @Override
    public void doRevoke(CustomSignRevokeParam revokeParamObject) throws Exception {
        List tasks = this.bpmTaskManager.getByInstId(revokeParamObject.getInstanceId());
        if (BeanUtils.isEmpty((Object)tasks)) {
            throw new BaseException("\u5df2\u6ca1\u6709\u4efb\u52a1\u53ef\u4ee5\u64a4\u56de");
        }
        DefaultBpmTask runningBpmTask = (DefaultBpmTask)tasks.get(0);
        if (revokeParamObject.getTargetNodeId().equals(runningBpmTask.getNodeId())) {
            this.bpmTaskManager.approvalTaskRevoke(runningBpmTask.getId(), revokeParamObject.getTargetTaskId());
        } else {
            this.bpmTaskManager.taskAnRevoke(revokeParamObject.getInstanceId(), runningBpmTask.getId(), revokeParamObject.getTargetNodeId(), revokeParamObject.getTargetTaskId());
        }
    }
}

